package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.__integer
import scala.jdk.CollectionConverters.*
final case class StreamSelection(
    maxVideoBitsPerSecond: Optional[__integer] = Optional.Absent,
    minVideoBitsPerSecond: Optional[__integer] = Optional.Absent,
    streamOrder: Optional[zio.aws.mediapackage.model.StreamOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.StreamSelection = {
    import StreamSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.StreamSelection
      .builder()
      .optionallyWith(maxVideoBitsPerSecond.map(value => value: Integer))(
        _.maxVideoBitsPerSecond
      )
      .optionallyWith(minVideoBitsPerSecond.map(value => value: Integer))(
        _.minVideoBitsPerSecond
      )
      .optionallyWith(streamOrder.map(value => value.unwrap))(_.streamOrder)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.StreamSelection.ReadOnly =
    zio.aws.mediapackage.model.StreamSelection.wrap(buildAwsValue())
}
object StreamSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.StreamSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.StreamSelection =
      zio.aws.mediapackage.model.StreamSelection(
        maxVideoBitsPerSecond.map(value => value),
        minVideoBitsPerSecond.map(value => value),
        streamOrder.map(value => value)
      )
    def maxVideoBitsPerSecond: Optional[__integer]
    def minVideoBitsPerSecond: Optional[__integer]
    def streamOrder: Optional[zio.aws.mediapackage.model.StreamOrder]
    def getMaxVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxVideoBitsPerSecond", maxVideoBitsPerSecond)
    def getMinVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minVideoBitsPerSecond", minVideoBitsPerSecond)
    def getStreamOrder
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.StreamOrder] =
      AwsError.unwrapOptionField("streamOrder", streamOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.StreamSelection
  ) extends zio.aws.mediapackage.model.StreamSelection.ReadOnly {
    override val maxVideoBitsPerSecond: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxVideoBitsPerSecond())
        .map(value => value: __integer)
    override val minVideoBitsPerSecond: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minVideoBitsPerSecond())
        .map(value => value: __integer)
    override val streamOrder: Optional[zio.aws.mediapackage.model.StreamOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamOrder())
        .map(value => zio.aws.mediapackage.model.StreamOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.StreamSelection
  ): zio.aws.mediapackage.model.StreamSelection.ReadOnly = new Wrapper(impl)
}
