package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters.*
final case class DashPackage(
    adTriggers: Optional[
      Iterable[zio.aws.mediapackage.model.AdTriggersElement]
    ] = Optional.Absent,
    adsOnDeliveryRestrictions: Optional[
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = Optional.Absent,
    encryption: Optional[zio.aws.mediapackage.model.DashEncryption] =
      Optional.Absent,
    manifestLayout: Optional[zio.aws.mediapackage.model.ManifestLayout] =
      Optional.Absent,
    manifestWindowSeconds: Optional[__integer] = Optional.Absent,
    minBufferTimeSeconds: Optional[__integer] = Optional.Absent,
    minUpdatePeriodSeconds: Optional[__integer] = Optional.Absent,
    periodTriggers: Optional[
      Iterable[zio.aws.mediapackage.model.PeriodTriggersElement]
    ] = Optional.Absent,
    profile: Optional[zio.aws.mediapackage.model.Profile] = Optional.Absent,
    segmentDurationSeconds: Optional[__integer] = Optional.Absent,
    segmentTemplateFormat: Optional[
      zio.aws.mediapackage.model.SegmentTemplateFormat
    ] = Optional.Absent,
    streamSelection: Optional[zio.aws.mediapackage.model.StreamSelection] =
      Optional.Absent,
    suggestedPresentationDelaySeconds: Optional[__integer] = Optional.Absent,
    utcTiming: Optional[zio.aws.mediapackage.model.UtcTiming] = Optional.Absent,
    utcTimingUri: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DashPackage = {
    import DashPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DashPackage
      .builder()
      .optionallyWith(
        adTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adTriggersWithStrings)
      .optionallyWith(adsOnDeliveryRestrictions.map(value => value.unwrap))(
        _.adsOnDeliveryRestrictions
      )
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(manifestLayout.map(value => value.unwrap))(
        _.manifestLayout
      )
      .optionallyWith(manifestWindowSeconds.map(value => value: Integer))(
        _.manifestWindowSeconds
      )
      .optionallyWith(minBufferTimeSeconds.map(value => value: Integer))(
        _.minBufferTimeSeconds
      )
      .optionallyWith(minUpdatePeriodSeconds.map(value => value: Integer))(
        _.minUpdatePeriodSeconds
      )
      .optionallyWith(
        periodTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.periodTriggersWithStrings)
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(segmentTemplateFormat.map(value => value.unwrap))(
        _.segmentTemplateFormat
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .optionallyWith(
        suggestedPresentationDelaySeconds.map(value => value: Integer)
      )(_.suggestedPresentationDelaySeconds)
      .optionallyWith(utcTiming.map(value => value.unwrap))(_.utcTiming)
      .optionallyWith(utcTimingUri.map(value => value: java.lang.String))(
        _.utcTimingUri
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.DashPackage.ReadOnly =
    zio.aws.mediapackage.model.DashPackage.wrap(buildAwsValue())
}
object DashPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DashPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DashPackage =
      zio.aws.mediapackage.model.DashPackage(
        adTriggers.map(value => value),
        adsOnDeliveryRestrictions.map(value => value),
        encryption.map(value => value.asEditable),
        manifestLayout.map(value => value),
        manifestWindowSeconds.map(value => value),
        minBufferTimeSeconds.map(value => value),
        minUpdatePeriodSeconds.map(value => value),
        periodTriggers.map(value => value),
        profile.map(value => value),
        segmentDurationSeconds.map(value => value),
        segmentTemplateFormat.map(value => value),
        streamSelection.map(value => value.asEditable),
        suggestedPresentationDelaySeconds.map(value => value),
        utcTiming.map(value => value),
        utcTimingUri.map(value => value)
      )
    def adTriggers: Optional[List[zio.aws.mediapackage.model.AdTriggersElement]]
    def adsOnDeliveryRestrictions
        : Optional[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions]
    def encryption: Optional[zio.aws.mediapackage.model.DashEncryption.ReadOnly]
    def manifestLayout: Optional[zio.aws.mediapackage.model.ManifestLayout]
    def manifestWindowSeconds: Optional[__integer]
    def minBufferTimeSeconds: Optional[__integer]
    def minUpdatePeriodSeconds: Optional[__integer]
    def periodTriggers
        : Optional[List[zio.aws.mediapackage.model.PeriodTriggersElement]]
    def profile: Optional[zio.aws.mediapackage.model.Profile]
    def segmentDurationSeconds: Optional[__integer]
    def segmentTemplateFormat
        : Optional[zio.aws.mediapackage.model.SegmentTemplateFormat]
    def streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def suggestedPresentationDelaySeconds: Optional[__integer]
    def utcTiming: Optional[zio.aws.mediapackage.model.UtcTiming]
    def utcTimingUri: Optional[__string]
    def getAdTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.AdTriggersElement
    ]] = AwsError.unwrapOptionField("adTriggers", adTriggers)
    def getAdsOnDeliveryRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = AwsError.unwrapOptionField(
      "adsOnDeliveryRestrictions",
      adsOnDeliveryRestrictions
    )
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.DashEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getManifestLayout
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.ManifestLayout] =
      AwsError.unwrapOptionField("manifestLayout", manifestLayout)
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getMinBufferTimeSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minBufferTimeSeconds", minBufferTimeSeconds)
    def getMinUpdatePeriodSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("minUpdatePeriodSeconds", minUpdatePeriodSeconds)
    def getPeriodTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.PeriodTriggersElement
    ]] = AwsError.unwrapOptionField("periodTriggers", periodTriggers)
    def getProfile: ZIO[Any, AwsError, zio.aws.mediapackage.model.Profile] =
      AwsError.unwrapOptionField("profile", profile)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentTemplateFormat
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.SegmentTemplateFormat] =
      AwsError.unwrapOptionField("segmentTemplateFormat", segmentTemplateFormat)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
    def getSuggestedPresentationDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "suggestedPresentationDelaySeconds",
        suggestedPresentationDelaySeconds
      )
    def getUtcTiming: ZIO[Any, AwsError, zio.aws.mediapackage.model.UtcTiming] =
      AwsError.unwrapOptionField("utcTiming", utcTiming)
    def getUtcTimingUri: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("utcTimingUri", utcTimingUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DashPackage
  ) extends zio.aws.mediapackage.model.DashPackage.ReadOnly {
    override val adTriggers
        : Optional[List[zio.aws.mediapackage.model.AdTriggersElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.AdTriggersElement.wrap(item)
          }.toList
        )
    override val adsOnDeliveryRestrictions
        : Optional[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adsOnDeliveryRestrictions())
        .map(value =>
          zio.aws.mediapackage.model.AdsOnDeliveryRestrictions.wrap(value)
        )
    override val encryption
        : Optional[zio.aws.mediapackage.model.DashEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.mediapackage.model.DashEncryption.wrap(value))
    override val manifestLayout
        : Optional[zio.aws.mediapackage.model.ManifestLayout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestLayout())
        .map(value => zio.aws.mediapackage.model.ManifestLayout.wrap(value))
    override val manifestWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestWindowSeconds())
        .map(value => value: __integer)
    override val minBufferTimeSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minBufferTimeSeconds())
        .map(value => value: __integer)
    override val minUpdatePeriodSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minUpdatePeriodSeconds())
        .map(value => value: __integer)
    override val periodTriggers
        : Optional[List[zio.aws.mediapackage.model.PeriodTriggersElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.periodTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.PeriodTriggersElement.wrap(item)
          }.toList
        )
    override val profile: Optional[zio.aws.mediapackage.model.Profile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profile())
        .map(value => zio.aws.mediapackage.model.Profile.wrap(value))
    override val segmentDurationSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentDurationSeconds())
        .map(value => value: __integer)
    override val segmentTemplateFormat
        : Optional[zio.aws.mediapackage.model.SegmentTemplateFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentTemplateFormat())
        .map(value =>
          zio.aws.mediapackage.model.SegmentTemplateFormat.wrap(value)
        )
    override val streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSelection())
        .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
    override val suggestedPresentationDelaySeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestedPresentationDelaySeconds())
        .map(value => value: __integer)
    override val utcTiming: Optional[zio.aws.mediapackage.model.UtcTiming] =
      zio.aws.core.internal
        .optionalFromNullable(impl.utcTiming())
        .map(value => zio.aws.mediapackage.model.UtcTiming.wrap(value))
    override val utcTimingUri: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.utcTimingUri())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DashPackage
  ): zio.aws.mediapackage.model.DashPackage.ReadOnly = new Wrapper(impl)
}
