package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.{__integer, __boolean, __string}
import scala.jdk.CollectionConverters.*
final case class HlsManifestCreateOrUpdateParameters(
    adMarkers: Optional[zio.aws.mediapackage.model.AdMarkers] = Optional.Absent,
    adTriggers: Optional[
      Iterable[zio.aws.mediapackage.model.AdTriggersElement]
    ] = Optional.Absent,
    adsOnDeliveryRestrictions: Optional[
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = Optional.Absent,
    id: __string,
    includeIframeOnlyStream: Optional[__boolean] = Optional.Absent,
    manifestName: Optional[__string] = Optional.Absent,
    playlistType: Optional[zio.aws.mediapackage.model.PlaylistType] =
      Optional.Absent,
    playlistWindowSeconds: Optional[__integer] = Optional.Absent,
    programDateTimeIntervalSeconds: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsManifestCreateOrUpdateParameters = {
    import HlsManifestCreateOrUpdateParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsManifestCreateOrUpdateParameters
      .builder()
      .optionallyWith(adMarkers.map(value => value.unwrap))(_.adMarkers)
      .optionallyWith(
        adTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adTriggersWithStrings)
      .optionallyWith(adsOnDeliveryRestrictions.map(value => value.unwrap))(
        _.adsOnDeliveryRestrictions
      )
      .id(id: java.lang.String)
      .optionallyWith(
        includeIframeOnlyStream.map(value => value: java.lang.Boolean)
      )(_.includeIframeOnlyStream)
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(playlistType.map(value => value.unwrap))(_.playlistType)
      .optionallyWith(playlistWindowSeconds.map(value => value: Integer))(
        _.playlistWindowSeconds
      )
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value => value: Integer)
      )(_.programDateTimeIntervalSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters.ReadOnly =
    zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters
      .wrap(buildAwsValue())
}
object HlsManifestCreateOrUpdateParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsManifestCreateOrUpdateParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters =
      zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters(
        adMarkers.map(value => value),
        adTriggers.map(value => value),
        adsOnDeliveryRestrictions.map(value => value),
        id,
        includeIframeOnlyStream.map(value => value),
        manifestName.map(value => value),
        playlistType.map(value => value),
        playlistWindowSeconds.map(value => value),
        programDateTimeIntervalSeconds.map(value => value)
      )
    def adMarkers: Optional[zio.aws.mediapackage.model.AdMarkers]
    def adTriggers: Optional[List[zio.aws.mediapackage.model.AdTriggersElement]]
    def adsOnDeliveryRestrictions
        : Optional[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions]
    def id: __string
    def includeIframeOnlyStream: Optional[__boolean]
    def manifestName: Optional[__string]
    def playlistType: Optional[zio.aws.mediapackage.model.PlaylistType]
    def playlistWindowSeconds: Optional[__integer]
    def programDateTimeIntervalSeconds: Optional[__integer]
    def getAdMarkers: ZIO[Any, AwsError, zio.aws.mediapackage.model.AdMarkers] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getAdTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.AdTriggersElement
    ]] = AwsError.unwrapOptionField("adTriggers", adTriggers)
    def getAdsOnDeliveryRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = AwsError.unwrapOptionField(
      "adsOnDeliveryRestrictions",
      adsOnDeliveryRestrictions
    )
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getIncludeIframeOnlyStream: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("includeIframeOnlyStream", includeIframeOnlyStream)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getPlaylistType
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.PlaylistType] =
      AwsError.unwrapOptionField("playlistType", playlistType)
    def getPlaylistWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("playlistWindowSeconds", playlistWindowSeconds)
    def getProgramDateTimeIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "programDateTimeIntervalSeconds",
        programDateTimeIntervalSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsManifestCreateOrUpdateParameters
  ) extends zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters.ReadOnly {
    override val adMarkers: Optional[zio.aws.mediapackage.model.AdMarkers] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adMarkers())
        .map(value => zio.aws.mediapackage.model.AdMarkers.wrap(value))
    override val adTriggers
        : Optional[List[zio.aws.mediapackage.model.AdTriggersElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.AdTriggersElement.wrap(item)
          }.toList
        )
    override val adsOnDeliveryRestrictions
        : Optional[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adsOnDeliveryRestrictions())
        .map(value =>
          zio.aws.mediapackage.model.AdsOnDeliveryRestrictions.wrap(value)
        )
    override val id: __string = impl.id(): __string
    override val includeIframeOnlyStream: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeIframeOnlyStream())
        .map(value => value: __boolean)
    override val manifestName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.manifestName())
      .map(value => value: __string)
    override val playlistType
        : Optional[zio.aws.mediapackage.model.PlaylistType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playlistType())
        .map(value => zio.aws.mediapackage.model.PlaylistType.wrap(value))
    override val playlistWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playlistWindowSeconds())
        .map(value => value: __integer)
    override val programDateTimeIntervalSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.programDateTimeIntervalSeconds())
        .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsManifestCreateOrUpdateParameters
  ): zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters.ReadOnly =
    new Wrapper(impl)
}
