package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SpekeKeyProvider(
    certificateArn: Optional[__string] = Optional.Absent,
    encryptionContractConfiguration: Optional[
      zio.aws.mediapackage.model.EncryptionContractConfiguration
    ] = Optional.Absent,
    resourceId: __string,
    roleArn: __string,
    systemIds: Iterable[__string],
    url: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider = {
    import SpekeKeyProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider
      .builder()
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(
        encryptionContractConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionContractConfiguration)
      .resourceId(resourceId: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .systemIds(systemIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .url(url: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
    zio.aws.mediapackage.model.SpekeKeyProvider.wrap(buildAwsValue())
}
object SpekeKeyProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.SpekeKeyProvider =
      zio.aws.mediapackage.model.SpekeKeyProvider(
        certificateArn.map(value => value),
        encryptionContractConfiguration.map(value => value.asEditable),
        resourceId,
        roleArn,
        systemIds,
        url
      )
    def certificateArn: Optional[__string]
    def encryptionContractConfiguration: Optional[
      zio.aws.mediapackage.model.EncryptionContractConfiguration.ReadOnly
    ]
    def resourceId: __string
    def roleArn: __string
    def systemIds: List[__string]
    def url: __string
    def getCertificateArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getEncryptionContractConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.EncryptionContractConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionContractConfiguration",
      encryptionContractConfiguration
    )
    def getResourceId: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceId)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getSystemIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(systemIds)
    def getUrl: ZIO[Any, Nothing, __string] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider
  ) extends zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly {
    override val certificateArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: __string)
    override val encryptionContractConfiguration: Optional[
      zio.aws.mediapackage.model.EncryptionContractConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionContractConfiguration())
      .map(value =>
        zio.aws.mediapackage.model.EncryptionContractConfiguration.wrap(value)
      )
    override val resourceId: __string = impl.resourceId(): __string
    override val roleArn: __string = impl.roleArn(): __string
    override val systemIds: List[__string] = impl
      .systemIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val url: __string = impl.url(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider
  ): zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly = new Wrapper(impl)
}
