package zio.aws.mediapackage
import zio.aws.mediapackage.model.DeleteOriginEndpointResponse.ReadOnly
import software.amazon.awssdk.services.mediapackage.{
  MediaPackageAsyncClientBuilder,
  MediaPackageAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.mediapackage.model.{
  DeleteChannelRequest,
  CreateChannelRequest,
  DeleteOriginEndpointRequest,
  ListTagsForResourceRequest,
  ListOriginEndpointsRequest,
  UpdateOriginEndpointRequest,
  UpdateChannelRequest,
  DescribeHarvestJobRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  ConfigureLogsRequest,
  RotateIngestEndpointCredentialsRequest,
  CreateOriginEndpointRequest,
  DescribeChannelRequest,
  ListHarvestJobsRequest,
  CreateHarvestJobRequest,
  TagResourceRequest,
  DescribeOriginEndpointRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.mediapackage.model.{
  DeleteOriginEndpointResponse,
  DescribeOriginEndpointResponse,
  CreateOriginEndpointResponse,
  CreateChannelResponse,
  UpdateOriginEndpointResponse,
  UpdateChannelResponse,
  ListChannelsResponse,
  CreateHarvestJobResponse,
  DescribeChannelResponse,
  ListHarvestJobsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  RotateIngestEndpointCredentialsResponse,
  OriginEndpoint,
  DescribeHarvestJobResponse,
  HarvestJob,
  ConfigureLogsResponse,
  Channel,
  TagResourceResponse,
  DeleteChannelResponse,
  ListOriginEndpointsResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MediaPackage extends AspectSupport[MediaPackage] {
  val api: MediaPackageAsyncClient
  def listChannels(
      request: ListChannelsRequest
  ): ZStream[Any, AwsError, zio.aws.mediapackage.model.Channel.ReadOnly]
  def listChannelsPaginated(
      request: ListChannelsRequest
  ): IO[AwsError, zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly]
  def rotateIngestEndpointCredentials(
      request: RotateIngestEndpointCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.mediapackage.model.RotateIngestEndpointCredentialsResponse.ReadOnly
  ]
  def updateOriginEndpoint(request: UpdateOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackage.model.UpdateOriginEndpointResponse.ReadOnly
  ]
  def configureLogs(
      request: ConfigureLogsRequest
  ): IO[AwsError, zio.aws.mediapackage.model.ConfigureLogsResponse.ReadOnly]
  def deleteChannel(
      request: DeleteChannelRequest
  ): IO[AwsError, zio.aws.mediapackage.model.DeleteChannelResponse.ReadOnly]
  def createChannel(
      request: CreateChannelRequest
  ): IO[AwsError, zio.aws.mediapackage.model.CreateChannelResponse.ReadOnly]
  def deleteOriginEndpoint(
      request: DeleteOriginEndpointRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def describeHarvestJob(request: DescribeHarvestJobRequest): IO[
    AwsError,
    zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.mediapackage.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeOriginEndpoint(request: DescribeOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackage.model.DescribeOriginEndpointResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def describeChannel(
      request: DescribeChannelRequest
  ): IO[AwsError, zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly]
  def listHarvestJobs(
      request: ListHarvestJobsRequest
  ): ZStream[Any, AwsError, zio.aws.mediapackage.model.HarvestJob.ReadOnly]
  def listHarvestJobsPaginated(
      request: ListHarvestJobsRequest
  ): IO[AwsError, zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly]
  def createOriginEndpoint(request: CreateOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly
  ]
  def listOriginEndpoints(
      request: ListOriginEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.mediapackage.model.OriginEndpoint.ReadOnly]
  def listOriginEndpointsPaginated(request: ListOriginEndpointsRequest): IO[
    AwsError,
    zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly
  ]
  def updateChannel(
      request: UpdateChannelRequest
  ): IO[AwsError, zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly]
  def createHarvestJob(
      request: CreateHarvestJobRequest
  ): IO[AwsError, zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly]
}
object MediaPackage {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaPackage] = customized(
    identity
  )
  def customized(
      customization: MediaPackageAsyncClientBuilder => MediaPackageAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaPackage] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MediaPackageAsyncClientBuilder => MediaPackageAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MediaPackage] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MediaPackageAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaPackageAsyncClient, MediaPackageAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      MediaPackageAsyncClient,
      MediaPackageAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new MediaPackageImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MediaPackageImpl[R](
      override val api: MediaPackageAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaPackage
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaPackage"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaPackageImpl[R1] = new MediaPackageImpl(api, newAspect, r)
    def listChannels(
        request: ListChannelsRequest
    ): ZStream[Any, AwsError, zio.aws.mediapackage.model.Channel.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.mediapackage.model.ListChannelsRequest,
        ListChannelsResponse,
        Channel
      ](
        "listChannels",
        api.listChannels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.channels().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.mediapackage.model.Channel.wrap(item))
        .provideEnvironment(r)
    def listChannelsPaginated(
        request: ListChannelsRequest
    ): IO[AwsError, zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.ListChannelsRequest,
        ListChannelsResponse
      ]("listChannels", api.listChannels)(request.buildAwsValue())
        .map(zio.aws.mediapackage.model.ListChannelsResponse.wrap)
        .provideEnvironment(r)
    def rotateIngestEndpointCredentials(
        request: RotateIngestEndpointCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.mediapackage.model.RotateIngestEndpointCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.RotateIngestEndpointCredentialsRequest,
      RotateIngestEndpointCredentialsResponse
    ]("rotateIngestEndpointCredentials", api.rotateIngestEndpointCredentials)(
      request.buildAwsValue()
    ).map(
      zio.aws.mediapackage.model.RotateIngestEndpointCredentialsResponse.wrap
    ).provideEnvironment(r)
    def updateOriginEndpoint(request: UpdateOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.UpdateOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.UpdateOriginEndpointRequest,
      UpdateOriginEndpointResponse
    ]("updateOriginEndpoint", api.updateOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.UpdateOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def configureLogs(
        request: ConfigureLogsRequest
    ): IO[AwsError, zio.aws.mediapackage.model.ConfigureLogsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.ConfigureLogsRequest,
        ConfigureLogsResponse
      ]("configureLogs", api.configureLogs)(request.buildAwsValue())
        .map(zio.aws.mediapackage.model.ConfigureLogsResponse.wrap)
        .provideEnvironment(r)
    def deleteChannel(
        request: DeleteChannelRequest
    ): IO[AwsError, zio.aws.mediapackage.model.DeleteChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.DeleteChannelRequest,
        DeleteChannelResponse
      ]("deleteChannel", api.deleteChannel)(request.buildAwsValue())
        .map(zio.aws.mediapackage.model.DeleteChannelResponse.wrap)
        .provideEnvironment(r)
    def createChannel(
        request: CreateChannelRequest
    ): IO[AwsError, zio.aws.mediapackage.model.CreateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.CreateChannelRequest,
        CreateChannelResponse
      ]("createChannel", api.createChannel)(request.buildAwsValue())
        .map(zio.aws.mediapackage.model.CreateChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteOriginEndpoint(
        request: DeleteOriginEndpointRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.DeleteOriginEndpointRequest,
      DeleteOriginEndpointResponse
    ]("deleteOriginEndpoint", api.deleteOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.DeleteOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeHarvestJob(request: DescribeHarvestJobRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobRequest,
      DescribeHarvestJobResponse
    ]("describeHarvestJob", api.describeHarvestJob)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.DescribeHarvestJobResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeOriginEndpoint(request: DescribeOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.DescribeOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.DescribeOriginEndpointRequest,
      DescribeOriginEndpointResponse
    ]("describeOriginEndpoint", api.describeOriginEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.mediapackage.model.DescribeOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeChannel(request: DescribeChannelRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.DescribeChannelRequest,
      DescribeChannelResponse
    ]("describeChannel", api.describeChannel)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.DescribeChannelResponse.wrap)
      .provideEnvironment(r)
    def listHarvestJobs(request: ListHarvestJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackage.model.HarvestJob.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest,
      ListHarvestJobsResponse,
      HarvestJob
    ](
      "listHarvestJobs",
      api.listHarvestJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.harvestJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediapackage.model.HarvestJob.wrap(item))
      .provideEnvironment(r)
    def listHarvestJobsPaginated(request: ListHarvestJobsRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest,
      ListHarvestJobsResponse
    ]("listHarvestJobs", api.listHarvestJobs)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.ListHarvestJobsResponse.wrap)
      .provideEnvironment(r)
    def createOriginEndpoint(request: CreateOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest,
      CreateOriginEndpointResponse
    ]("createOriginEndpoint", api.createOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.CreateOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def listOriginEndpoints(request: ListOriginEndpointsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackage.model.OriginEndpoint.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest,
      ListOriginEndpointsResponse,
      OriginEndpoint
    ](
      "listOriginEndpoints",
      api.listOriginEndpoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.originEndpoints().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediapackage.model.OriginEndpoint.wrap(item))
      .provideEnvironment(r)
    def listOriginEndpointsPaginated(request: ListOriginEndpointsRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest,
      ListOriginEndpointsResponse
    ]("listOriginEndpoints", api.listOriginEndpoints)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.ListOriginEndpointsResponse.wrap)
      .provideEnvironment(r)
    def updateChannel(
        request: UpdateChannelRequest
    ): IO[AwsError, zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackage.model.UpdateChannelRequest,
        UpdateChannelResponse
      ]("updateChannel", api.updateChannel)(request.buildAwsValue())
        .map(zio.aws.mediapackage.model.UpdateChannelResponse.wrap)
        .provideEnvironment(r)
    def createHarvestJob(request: CreateHarvestJobRequest): IO[
      AwsError,
      zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobRequest,
      CreateHarvestJobResponse
    ]("createHarvestJob", api.createHarvestJob)(request.buildAwsValue())
      .map(zio.aws.mediapackage.model.CreateHarvestJobResponse.wrap)
      .provideEnvironment(r)
  }
  def listChannels(request: ListChannelsRequest): ZStream[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.Channel.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannels(request))
  def listChannelsPaginated(request: ListChannelsRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelsPaginated(request))
  def rotateIngestEndpointCredentials(
      request: RotateIngestEndpointCredentialsRequest
  ): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.RotateIngestEndpointCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rotateIngestEndpointCredentials(request))
  def updateOriginEndpoint(request: UpdateOriginEndpointRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.UpdateOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOriginEndpoint(request))
  def configureLogs(request: ConfigureLogsRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.ConfigureLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureLogs(request))
  def deleteChannel(request: DeleteChannelRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.DeleteChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannel(request))
  def createChannel(request: CreateChannelRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def deleteOriginEndpoint(
      request: DeleteOriginEndpointRequest
  ): ZIO[zio.aws.mediapackage.MediaPackage, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteOriginEndpoint(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.mediapackage.MediaPackage, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def describeHarvestJob(request: DescribeHarvestJobRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHarvestJob(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeOriginEndpoint(request: DescribeOriginEndpointRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.DescribeOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOriginEndpoint(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.mediapackage.MediaPackage, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def describeChannel(request: DescribeChannelRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannel(request))
  def listHarvestJobs(request: ListHarvestJobsRequest): ZStream[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.HarvestJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listHarvestJobs(request))
  def listHarvestJobsPaginated(request: ListHarvestJobsRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHarvestJobsPaginated(request))
  def createOriginEndpoint(request: CreateOriginEndpointRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOriginEndpoint(request))
  def listOriginEndpoints(request: ListOriginEndpointsRequest): ZStream[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.OriginEndpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.listOriginEndpoints(request))
  def listOriginEndpointsPaginated(request: ListOriginEndpointsRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOriginEndpointsPaginated(request))
  def updateChannel(request: UpdateChannelRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
  def createHarvestJob(request: CreateHarvestJobRequest): ZIO[
    zio.aws.mediapackage.MediaPackage,
    AwsError,
    zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHarvestJob(request))
}
