package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListHarvestJobsResponse(
    harvestJobs: Optional[Iterable[zio.aws.mediapackage.model.HarvestJob]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse = {
    import ListHarvestJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse
      .builder()
      .optionallyWith(
        harvestJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.harvestJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly =
    zio.aws.mediapackage.model.ListHarvestJobsResponse.wrap(buildAwsValue())
}
object ListHarvestJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ListHarvestJobsResponse =
      zio.aws.mediapackage.model.ListHarvestJobsResponse(
        harvestJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def harvestJobs
        : Optional[List[zio.aws.mediapackage.model.HarvestJob.ReadOnly]]
    def nextToken: Optional[__string]
    def getHarvestJobs: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.HarvestJob.ReadOnly
    ]] = AwsError.unwrapOptionField("harvestJobs", harvestJobs)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse
  ) extends zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly {
    override val harvestJobs
        : Optional[List[zio.aws.mediapackage.model.HarvestJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.harvestJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.HarvestJob.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse
  ): zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
