package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.Status
  ): zio.aws.mediapackage.model.Status = value match {
    case software.amazon.awssdk.services.mediapackage.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.Status.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.mediapackage.model.Status.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.mediapackage.model.Status.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediapackage.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Status =
      software.amazon.awssdk.services.mediapackage.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.mediapackage.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Status =
      software.amazon.awssdk.services.mediapackage.model.Status.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.mediapackage.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Status =
      software.amazon.awssdk.services.mediapackage.model.Status.SUCCEEDED
  }
  case object FAILED extends zio.aws.mediapackage.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Status =
      software.amazon.awssdk.services.mediapackage.model.Status.FAILED
  }
}
