package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateChannelRequest(
    description: Option[__string] = None,
    id: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CreateChannelRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .id(id: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.CreateChannelRequest.ReadOnly =
    zio.aws.mediapackage.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CreateChannelRequest =
      zio.aws.mediapackage.model.CreateChannelRequest(
        description.map(value => value),
        id,
        tags.map(value => value)
      )
    def description: Option[__string]
    def id: __string
    def tags: Option[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateChannelRequest
  ) extends zio.aws.mediapackage.model.CreateChannelRequest.ReadOnly {
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val id: __string = impl.id(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateChannelRequest
  ): zio.aws.mediapackage.model.CreateChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
