package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__integer, __boolean, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HlsManifest(
    adMarkers: Option[zio.aws.mediapackage.model.AdMarkers] = None,
    id: __string,
    includeIframeOnlyStream: Option[__boolean] = None,
    manifestName: Option[__string] = None,
    playlistType: Option[zio.aws.mediapackage.model.PlaylistType] = None,
    playlistWindowSeconds: Option[__integer] = None,
    programDateTimeIntervalSeconds: Option[__integer] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsManifest = {
    import HlsManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsManifest
      .builder()
      .optionallyWith(adMarkers.map(value => value.unwrap))(_.adMarkers)
      .id(id: java.lang.String)
      .optionallyWith(
        includeIframeOnlyStream.map(value => value: java.lang.Boolean)
      )(_.includeIframeOnlyStream)
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(playlistType.map(value => value.unwrap))(_.playlistType)
      .optionallyWith(playlistWindowSeconds.map(value => value: Integer))(
        _.playlistWindowSeconds
      )
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value => value: Integer)
      )(_.programDateTimeIntervalSeconds)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.HlsManifest.ReadOnly =
    zio.aws.mediapackage.model.HlsManifest.wrap(buildAwsValue())
}
object HlsManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.HlsManifest =
      zio.aws.mediapackage.model.HlsManifest(
        adMarkers.map(value => value),
        id,
        includeIframeOnlyStream.map(value => value),
        manifestName.map(value => value),
        playlistType.map(value => value),
        playlistWindowSeconds.map(value => value),
        programDateTimeIntervalSeconds.map(value => value),
        url.map(value => value)
      )
    def adMarkers: Option[zio.aws.mediapackage.model.AdMarkers]
    def id: __string
    def includeIframeOnlyStream: Option[__boolean]
    def manifestName: Option[__string]
    def playlistType: Option[zio.aws.mediapackage.model.PlaylistType]
    def playlistWindowSeconds: Option[__integer]
    def programDateTimeIntervalSeconds: Option[__integer]
    def url: Option[__string]
    def getAdMarkers: ZIO[Any, AwsError, zio.aws.mediapackage.model.AdMarkers] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getIncludeIframeOnlyStream: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("includeIframeOnlyStream", includeIframeOnlyStream)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getPlaylistType
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.PlaylistType] =
      AwsError.unwrapOptionField("playlistType", playlistType)
    def getPlaylistWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("playlistWindowSeconds", playlistWindowSeconds)
    def getProgramDateTimeIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "programDateTimeIntervalSeconds",
        programDateTimeIntervalSeconds
      )
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsManifest
  ) extends zio.aws.mediapackage.model.HlsManifest.ReadOnly {
    override val adMarkers: Option[zio.aws.mediapackage.model.AdMarkers] = scala
      .Option(impl.adMarkers())
      .map(value => zio.aws.mediapackage.model.AdMarkers.wrap(value))
    override val id: __string = impl.id(): __string
    override val includeIframeOnlyStream: Option[__boolean] = scala
      .Option(impl.includeIframeOnlyStream())
      .map(value => value: __boolean)
    override val manifestName: Option[__string] =
      scala.Option(impl.manifestName()).map(value => value: __string)
    override val playlistType: Option[zio.aws.mediapackage.model.PlaylistType] =
      scala
        .Option(impl.playlistType())
        .map(value => zio.aws.mediapackage.model.PlaylistType.wrap(value))
    override val playlistWindowSeconds: Option[__integer] =
      scala.Option(impl.playlistWindowSeconds()).map(value => value: __integer)
    override val programDateTimeIntervalSeconds: Option[__integer] = scala
      .Option(impl.programDateTimeIntervalSeconds())
      .map(value => value: __integer)
    override val url: Option[__string] =
      scala.Option(impl.url()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsManifest
  ): zio.aws.mediapackage.model.HlsManifest.ReadOnly = new Wrapper(impl)
}
