package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateChannelResponse(
    arn: Option[__string] = None,
    description: Option[__string] = None,
    egressAccessLogs: Option[zio.aws.mediapackage.model.EgressAccessLogs] =
      None,
    hlsIngest: Option[zio.aws.mediapackage.model.HlsIngest] = None,
    id: Option[__string] = None,
    ingressAccessLogs: Option[zio.aws.mediapackage.model.IngressAccessLogs] =
      None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.UpdateChannelResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .optionallyWith(hlsIngest.map(value => value.buildAwsValue()))(
        _.hlsIngest
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(ingressAccessLogs.map(value => value.buildAwsValue()))(
        _.ingressAccessLogs
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly =
    zio.aws.mediapackage.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.UpdateChannelResponse =
      zio.aws.mediapackage.model.UpdateChannelResponse(
        arn.map(value => value),
        description.map(value => value),
        egressAccessLogs.map(value => value.asEditable),
        hlsIngest.map(value => value.asEditable),
        id.map(value => value),
        ingressAccessLogs.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def description: Option[__string]
    def egressAccessLogs
        : Option[zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly]
    def hlsIngest: Option[zio.aws.mediapackage.model.HlsIngest.ReadOnly]
    def id: Option[__string]
    def ingressAccessLogs
        : Option[zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getHlsIngest
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.HlsIngest.ReadOnly] =
      AwsError.unwrapOptionField("hlsIngest", hlsIngest)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIngressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("ingressAccessLogs", ingressAccessLogs)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.UpdateChannelResponse
  ) extends zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val egressAccessLogs
        : Option[zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly] = scala
      .Option(impl.egressAccessLogs())
      .map(value => zio.aws.mediapackage.model.EgressAccessLogs.wrap(value))
    override val hlsIngest
        : Option[zio.aws.mediapackage.model.HlsIngest.ReadOnly] = scala
      .Option(impl.hlsIngest())
      .map(value => zio.aws.mediapackage.model.HlsIngest.wrap(value))
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val ingressAccessLogs
        : Option[zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly] = scala
      .Option(impl.ingressAccessLogs())
      .map(value => zio.aws.mediapackage.model.IngressAccessLogs.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.UpdateChannelResponse
  ): zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
