package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{MaxResults, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOriginEndpointsRequest(
    channelId: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest = {
    import ListOriginEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest
      .builder()
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.ListOriginEndpointsRequest.ReadOnly =
    zio.aws.mediapackage.model.ListOriginEndpointsRequest.wrap(buildAwsValue())
}
object ListOriginEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ListOriginEndpointsRequest =
      zio.aws.mediapackage.model.ListOriginEndpointsRequest(
        channelId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelId: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest
  ) extends zio.aws.mediapackage.model.ListOriginEndpointsRequest.ReadOnly {
    override val channelId: Option[__string] =
      scala.Option(impl.channelId()).map(value => value: __string)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediapackage.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest
  ): zio.aws.mediapackage.model.ListOriginEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
