package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__integer, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CmafEncryption(
    constantInitializationVector: Option[__string] = None,
    keyRotationIntervalSeconds: Option[__integer] = None,
    spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CmafEncryption = {
    import CmafEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CmafEncryption
      .builder()
      .optionallyWith(
        constantInitializationVector.map(value => value: java.lang.String)
      )(_.constantInitializationVector)
      .optionallyWith(keyRotationIntervalSeconds.map(value => value: Integer))(
        _.keyRotationIntervalSeconds
      )
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.CmafEncryption.ReadOnly =
    zio.aws.mediapackage.model.CmafEncryption.wrap(buildAwsValue())
}
object CmafEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CmafEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CmafEncryption =
      zio.aws.mediapackage.model.CmafEncryption(
        constantInitializationVector.map(value => value),
        keyRotationIntervalSeconds.map(value => value),
        spekeKeyProvider.asEditable
      )
    def constantInitializationVector: Option[__string]
    def keyRotationIntervalSeconds: Option[__integer]
    def spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    def getConstantInitializationVector: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "constantInitializationVector",
        constantInitializationVector
      )
    def getKeyRotationIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "keyRotationIntervalSeconds",
        keyRotationIntervalSeconds
      )
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CmafEncryption
  ) extends zio.aws.mediapackage.model.CmafEncryption.ReadOnly {
    override val constantInitializationVector: Option[__string] = scala
      .Option(impl.constantInitializationVector())
      .map(value => value: __string)
    override val keyRotationIntervalSeconds: Option[__integer] = scala
      .Option(impl.keyRotationIntervalSeconds())
      .map(value => value: __integer)
    override val spekeKeyProvider
        : zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackage.model.SpekeKeyProvider.wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CmafEncryption
  ): zio.aws.mediapackage.model.CmafEncryption.ReadOnly = new Wrapper(impl)
}
