package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateHarvestJobResponse(
    arn: Option[__string] = None,
    channelId: Option[__string] = None,
    createdAt: Option[__string] = None,
    endTime: Option[__string] = None,
    id: Option[__string] = None,
    originEndpointId: Option[__string] = None,
    s3Destination: Option[zio.aws.mediapackage.model.S3Destination] = None,
    startTime: Option[__string] = None,
    status: Option[zio.aws.mediapackage.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobResponse = {
    import CreateHarvestJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(endTime.map(value => value: java.lang.String))(_.endTime)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(originEndpointId.map(value => value: java.lang.String))(
        _.originEndpointId
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .optionallyWith(startTime.map(value => value: java.lang.String))(
        _.startTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly =
    zio.aws.mediapackage.model.CreateHarvestJobResponse.wrap(buildAwsValue())
}
object CreateHarvestJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CreateHarvestJobResponse =
      zio.aws.mediapackage.model.CreateHarvestJobResponse(
        arn.map(value => value),
        channelId.map(value => value),
        createdAt.map(value => value),
        endTime.map(value => value),
        id.map(value => value),
        originEndpointId.map(value => value),
        s3Destination.map(value => value.asEditable),
        startTime.map(value => value),
        status.map(value => value)
      )
    def arn: Option[__string]
    def channelId: Option[__string]
    def createdAt: Option[__string]
    def endTime: Option[__string]
    def id: Option[__string]
    def originEndpointId: Option[__string]
    def s3Destination: Option[zio.aws.mediapackage.model.S3Destination.ReadOnly]
    def startTime: Option[__string]
    def status: Option[zio.aws.mediapackage.model.Status]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEndTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getOriginEndpointId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originEndpointId", originEndpointId)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.S3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
    def getStartTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.mediapackage.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobResponse
  ) extends zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val channelId: Option[__string] =
      scala.Option(impl.channelId()).map(value => value: __string)
    override val createdAt: Option[__string] =
      scala.Option(impl.createdAt()).map(value => value: __string)
    override val endTime: Option[__string] =
      scala.Option(impl.endTime()).map(value => value: __string)
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val originEndpointId: Option[__string] =
      scala.Option(impl.originEndpointId()).map(value => value: __string)
    override val s3Destination
        : Option[zio.aws.mediapackage.model.S3Destination.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.mediapackage.model.S3Destination.wrap(value))
    override val startTime: Option[__string] =
      scala.Option(impl.startTime()).map(value => value: __string)
    override val status: Option[zio.aws.mediapackage.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.mediapackage.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobResponse
  ): zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
