package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__integer, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateOriginEndpointRequest(
    authorization: Option[zio.aws.mediapackage.model.Authorization] = None,
    cmafPackage: Option[
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters
    ] = None,
    dashPackage: Option[zio.aws.mediapackage.model.DashPackage] = None,
    description: Option[__string] = None,
    hlsPackage: Option[zio.aws.mediapackage.model.HlsPackage] = None,
    id: __string,
    manifestName: Option[__string] = None,
    mssPackage: Option[zio.aws.mediapackage.model.MssPackage] = None,
    origination: Option[zio.aws.mediapackage.model.Origination] = None,
    startoverWindowSeconds: Option[__integer] = None,
    timeDelaySeconds: Option[__integer] = None,
    whitelist: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.UpdateOriginEndpointRequest = {
    import UpdateOriginEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.UpdateOriginEndpointRequest
      .builder()
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(
        manifestName.map(value => __string.unwrap(value): java.lang.String)
      )(_.manifestName)
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .optionallyWith(origination.map(value => value.unwrap))(_.origination)
      .optionallyWith(
        startoverWindowSeconds.map(value => __integer.unwrap(value): Integer)
      )(_.startoverWindowSeconds)
      .optionallyWith(
        timeDelaySeconds.map(value => __integer.unwrap(value): Integer)
      )(_.timeDelaySeconds)
      .optionallyWith(
        whitelist.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.whitelist)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.UpdateOriginEndpointRequest.ReadOnly =
    zio.aws.mediapackage.model.UpdateOriginEndpointRequest.wrap(buildAwsValue())
}
object UpdateOriginEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.UpdateOriginEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.UpdateOriginEndpointRequest =
      zio.aws.mediapackage.model.UpdateOriginEndpointRequest(
        authorization.map(value => value.asEditable),
        cmafPackage.map(value => value.asEditable),
        dashPackage.map(value => value.asEditable),
        description.map(value => value),
        hlsPackage.map(value => value.asEditable),
        id,
        manifestName.map(value => value),
        mssPackage.map(value => value.asEditable),
        origination.map(value => value),
        startoverWindowSeconds.map(value => value),
        timeDelaySeconds.map(value => value),
        whitelist.map(value => value)
      )
    def authorization: Option[zio.aws.mediapackage.model.Authorization.ReadOnly]
    def cmafPackage: Option[
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly
    ]
    def dashPackage: Option[zio.aws.mediapackage.model.DashPackage.ReadOnly]
    def description: Option[__string]
    def hlsPackage: Option[zio.aws.mediapackage.model.HlsPackage.ReadOnly]
    def id: __string
    def manifestName: Option[__string]
    def mssPackage: Option[zio.aws.mediapackage.model.MssPackage.ReadOnly]
    def origination: Option[zio.aws.mediapackage.model.Origination]
    def startoverWindowSeconds: Option[__integer]
    def timeDelaySeconds: Option[__integer]
    def whitelist: Option[List[__string]]
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getCmafPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly
    ] = AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getDashPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.DashPackage.ReadOnly] =
      AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHlsPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.HlsPackage.ReadOnly] =
      AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getMssPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.MssPackage.ReadOnly] =
      AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.Origination] =
      AwsError.unwrapOptionField("origination", origination)
    def getStartoverWindowSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("startoverWindowSeconds", startoverWindowSeconds)
    def getTimeDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeDelaySeconds", timeDelaySeconds)
    def getWhitelist: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("whitelist", whitelist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.UpdateOriginEndpointRequest
  ) extends zio.aws.mediapackage.model.UpdateOriginEndpointRequest.ReadOnly {
    override val authorization
        : Option[zio.aws.mediapackage.model.Authorization.ReadOnly] = scala
      .Option(impl.authorization())
      .map(value => zio.aws.mediapackage.model.Authorization.wrap(value))
    override val cmafPackage: Option[
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly
    ] = scala
      .Option(impl.cmafPackage())
      .map(value =>
        zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters
          .wrap(value)
      )
    override val dashPackage
        : Option[zio.aws.mediapackage.model.DashPackage.ReadOnly] = scala
      .Option(impl.dashPackage())
      .map(value => zio.aws.mediapackage.model.DashPackage.wrap(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val hlsPackage
        : Option[zio.aws.mediapackage.model.HlsPackage.ReadOnly] = scala
      .Option(impl.hlsPackage())
      .map(value => zio.aws.mediapackage.model.HlsPackage.wrap(value))
    override val id: __string =
      zio.aws.mediapackage.model.primitives.__string(impl.id())
    override val manifestName: Option[__string] = scala
      .Option(impl.manifestName())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val mssPackage
        : Option[zio.aws.mediapackage.model.MssPackage.ReadOnly] = scala
      .Option(impl.mssPackage())
      .map(value => zio.aws.mediapackage.model.MssPackage.wrap(value))
    override val origination: Option[zio.aws.mediapackage.model.Origination] =
      scala
        .Option(impl.origination())
        .map(value => zio.aws.mediapackage.model.Origination.wrap(value))
    override val startoverWindowSeconds: Option[__integer] = scala
      .Option(impl.startoverWindowSeconds())
      .map(value => zio.aws.mediapackage.model.primitives.__integer(value))
    override val timeDelaySeconds: Option[__integer] = scala
      .Option(impl.timeDelaySeconds())
      .map(value => zio.aws.mediapackage.model.primitives.__integer(value))
    override val whitelist: Option[List[__string]] = scala
      .Option(impl.whitelist())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.UpdateOriginEndpointRequest
  ): zio.aws.mediapackage.model.UpdateOriginEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
