package zio.aws.mediapackage
import zio.aws.mediapackage.model.DeleteOriginEndpointResponse.ReadOnly
import software.amazon.awssdk.services.mediapackage.MediaPackageAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.mediapackage.model.{
  DeleteChannelRequest,
  CreateChannelRequest,
  DeleteOriginEndpointRequest,
  ListTagsForResourceRequest,
  ListOriginEndpointsRequest,
  UpdateOriginEndpointRequest,
  UpdateChannelRequest,
  DescribeHarvestJobRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  ConfigureLogsRequest,
  RotateIngestEndpointCredentialsRequest,
  CreateOriginEndpointRequest,
  DescribeChannelRequest,
  ListHarvestJobsRequest,
  CreateHarvestJobRequest,
  TagResourceRequest,
  DescribeOriginEndpointRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object MediaPackageMock extends Mock[MediaPackage] {
  object ListChannels
      extends Stream[
        ListChannelsRequest,
        AwsError,
        zio.aws.mediapackage.model.Channel.ReadOnly
      ]
  object ListChannelsPaginated
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly
      ]
  object RotateIngestEndpointCredentials
      extends Effect[
        RotateIngestEndpointCredentialsRequest,
        AwsError,
        zio.aws.mediapackage.model.RotateIngestEndpointCredentialsResponse.ReadOnly
      ]
  object UpdateOriginEndpoint
      extends Effect[
        UpdateOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackage.model.UpdateOriginEndpointResponse.ReadOnly
      ]
  object ConfigureLogs
      extends Effect[
        ConfigureLogsRequest,
        AwsError,
        zio.aws.mediapackage.model.ConfigureLogsResponse.ReadOnly
      ]
  object DeleteChannel
      extends Effect[
        DeleteChannelRequest,
        AwsError,
        zio.aws.mediapackage.model.DeleteChannelResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.mediapackage.model.CreateChannelResponse.ReadOnly
      ]
  object DeleteOriginEndpoint
      extends Effect[DeleteOriginEndpointRequest, AwsError, ReadOnly]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DescribeHarvestJob
      extends Effect[
        DescribeHarvestJobRequest,
        AwsError,
        zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mediapackage.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeOriginEndpoint
      extends Effect[
        DescribeOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackage.model.DescribeOriginEndpointResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DescribeChannel
      extends Effect[
        DescribeChannelRequest,
        AwsError,
        zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly
      ]
  object ListHarvestJobs
      extends Stream[
        ListHarvestJobsRequest,
        AwsError,
        zio.aws.mediapackage.model.HarvestJob.ReadOnly
      ]
  object ListHarvestJobsPaginated
      extends Effect[
        ListHarvestJobsRequest,
        AwsError,
        zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly
      ]
  object CreateOriginEndpoint
      extends Effect[
        CreateOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly
      ]
  object ListOriginEndpoints
      extends Stream[
        ListOriginEndpointsRequest,
        AwsError,
        zio.aws.mediapackage.model.OriginEndpoint.ReadOnly
      ]
  object ListOriginEndpointsPaginated
      extends Effect[
        ListOriginEndpointsRequest,
        AwsError,
        zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly
      ]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly
      ]
  object CreateHarvestJob
      extends Effect[
        CreateHarvestJobRequest,
        AwsError,
        zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaPackage] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new MediaPackage {
          val api: MediaPackageAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : MediaPackage = this
          def listChannels(request: ListChannelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediapackage.model.Channel.ReadOnly
          ] = rts.unsafeRun(proxy(ListChannels, request))
          def listChannelsPaginated(request: ListChannelsRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly
          ] = proxy(ListChannelsPaginated, request)
          def rotateIngestEndpointCredentials(
              request: RotateIngestEndpointCredentialsRequest
          ): IO[
            AwsError,
            zio.aws.mediapackage.model.RotateIngestEndpointCredentialsResponse.ReadOnly
          ] = proxy(RotateIngestEndpointCredentials, request)
          def updateOriginEndpoint(request: UpdateOriginEndpointRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.UpdateOriginEndpointResponse.ReadOnly
          ] = proxy(UpdateOriginEndpoint, request)
          def configureLogs(request: ConfigureLogsRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.ConfigureLogsResponse.ReadOnly
          ] = proxy(ConfigureLogs, request)
          def deleteChannel(request: DeleteChannelRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.DeleteChannelResponse.ReadOnly
          ] = proxy(DeleteChannel, request)
          def createChannel(request: CreateChannelRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.CreateChannelResponse.ReadOnly
          ] = proxy(CreateChannel, request)
          def deleteOriginEndpoint(
              request: DeleteOriginEndpointRequest
          ): IO[AwsError, ReadOnly] = proxy(DeleteOriginEndpoint, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def describeHarvestJob(request: DescribeHarvestJobRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly
          ] = proxy(DescribeHarvestJob, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def describeOriginEndpoint(
              request: DescribeOriginEndpointRequest
          ): IO[
            AwsError,
            zio.aws.mediapackage.model.DescribeOriginEndpointResponse.ReadOnly
          ] = proxy(DescribeOriginEndpoint, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def describeChannel(request: DescribeChannelRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly
          ] = proxy(DescribeChannel, request)
          def listHarvestJobs(request: ListHarvestJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediapackage.model.HarvestJob.ReadOnly
          ] = rts.unsafeRun(proxy(ListHarvestJobs, request))
          def listHarvestJobsPaginated(request: ListHarvestJobsRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.ListHarvestJobsResponse.ReadOnly
          ] = proxy(ListHarvestJobsPaginated, request)
          def createOriginEndpoint(request: CreateOriginEndpointRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly
          ] = proxy(CreateOriginEndpoint, request)
          def listOriginEndpoints(request: ListOriginEndpointsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediapackage.model.OriginEndpoint.ReadOnly
          ] = rts.unsafeRun(proxy(ListOriginEndpoints, request))
          def listOriginEndpointsPaginated(
              request: ListOriginEndpointsRequest
          ): IO[
            AwsError,
            zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly
          ] = proxy(ListOriginEndpointsPaginated, request)
          def updateChannel(request: UpdateChannelRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.UpdateChannelResponse.ReadOnly
          ] = proxy(UpdateChannel, request)
          def createHarvestJob(request: CreateHarvestJobRequest): IO[
            AwsError,
            zio.aws.mediapackage.model.CreateHarvestJobResponse.ReadOnly
          ] = proxy(CreateHarvestJob, request)
        }
      }
    }
    .toLayer
}
