package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters.*
sealed trait Profile {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.Profile
}
object Profile {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.Profile
  ): zio.aws.mediapackage.model.Profile = value match {
    case software.amazon.awssdk.services.mediapackage.model.Profile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.Profile.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackage.model.Profile.HBBTV_1_5 =>
      val r = HBBTV_1_5
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediapackage.model.Profile {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Profile =
      software.amazon.awssdk.services.mediapackage.model.Profile.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.mediapackage.model.Profile {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Profile =
      software.amazon.awssdk.services.mediapackage.model.Profile.NONE
  }
  case object HBBTV_1_5 extends zio.aws.mediapackage.model.Profile {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Profile =
      software.amazon.awssdk.services.mediapackage.model.Profile.HBBTV_1_5
  }
}
