package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListChannelsResponse(
    channels: Option[Iterable[zio.aws.mediapackage.model.Channel]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly =
    zio.aws.mediapackage.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ListChannelsResponse =
      zio.aws.mediapackage.model.ListChannelsResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels: Option[List[zio.aws.mediapackage.model.Channel.ReadOnly]]
    def nextToken: Option[__string]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.Channel.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
  ) extends zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly {
    override val channels
        : Option[List[zio.aws.mediapackage.model.Channel.ReadOnly]] = scala
      .Option(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.Channel.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
  ): zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
