package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__integer, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOriginEndpointResponse(
    arn: Option[__string] = None,
    authorization: Option[zio.aws.mediapackage.model.Authorization] = None,
    channelId: Option[__string] = None,
    cmafPackage: Option[zio.aws.mediapackage.model.CmafPackage] = None,
    dashPackage: Option[zio.aws.mediapackage.model.DashPackage] = None,
    description: Option[__string] = None,
    hlsPackage: Option[zio.aws.mediapackage.model.HlsPackage] = None,
    id: Option[__string] = None,
    manifestName: Option[__string] = None,
    mssPackage: Option[zio.aws.mediapackage.model.MssPackage] = None,
    origination: Option[zio.aws.mediapackage.model.Origination] = None,
    startoverWindowSeconds: Option[__integer] = None,
    tags: Option[Map[__string, __string]] = None,
    timeDelaySeconds: Option[__integer] = None,
    url: Option[__string] = None,
    whitelist: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointResponse = {
    import CreateOriginEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(
        channelId.map(value => __string.unwrap(value): java.lang.String)
      )(_.channelId)
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        manifestName.map(value => __string.unwrap(value): java.lang.String)
      )(_.manifestName)
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .optionallyWith(origination.map(value => value.unwrap))(_.origination)
      .optionallyWith(
        startoverWindowSeconds.map(value => __integer.unwrap(value): Integer)
      )(_.startoverWindowSeconds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        timeDelaySeconds.map(value => __integer.unwrap(value): Integer)
      )(_.timeDelaySeconds)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        whitelist.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.whitelist)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly =
    zio.aws.mediapackage.model.CreateOriginEndpointResponse
      .wrap(buildAwsValue())
}
object CreateOriginEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CreateOriginEndpointResponse =
      zio.aws.mediapackage.model.CreateOriginEndpointResponse(
        arn.map(value => value),
        authorization.map(value => value.asEditable),
        channelId.map(value => value),
        cmafPackage.map(value => value.asEditable),
        dashPackage.map(value => value.asEditable),
        description.map(value => value),
        hlsPackage.map(value => value.asEditable),
        id.map(value => value),
        manifestName.map(value => value),
        mssPackage.map(value => value.asEditable),
        origination.map(value => value),
        startoverWindowSeconds.map(value => value),
        tags.map(value => value),
        timeDelaySeconds.map(value => value),
        url.map(value => value),
        whitelist.map(value => value)
      )
    def arn: Option[__string]
    def authorization: Option[zio.aws.mediapackage.model.Authorization.ReadOnly]
    def channelId: Option[__string]
    def cmafPackage: Option[zio.aws.mediapackage.model.CmafPackage.ReadOnly]
    def dashPackage: Option[zio.aws.mediapackage.model.DashPackage.ReadOnly]
    def description: Option[__string]
    def hlsPackage: Option[zio.aws.mediapackage.model.HlsPackage.ReadOnly]
    def id: Option[__string]
    def manifestName: Option[__string]
    def mssPackage: Option[zio.aws.mediapackage.model.MssPackage.ReadOnly]
    def origination: Option[zio.aws.mediapackage.model.Origination]
    def startoverWindowSeconds: Option[__integer]
    def tags: Option[Map[__string, __string]]
    def timeDelaySeconds: Option[__integer]
    def url: Option[__string]
    def whitelist: Option[List[__string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getCmafPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.CmafPackage.ReadOnly] =
      AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getDashPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.DashPackage.ReadOnly] =
      AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHlsPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.HlsPackage.ReadOnly] =
      AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getMssPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.MssPackage.ReadOnly] =
      AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.Origination] =
      AwsError.unwrapOptionField("origination", origination)
    def getStartoverWindowSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("startoverWindowSeconds", startoverWindowSeconds)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTimeDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeDelaySeconds", timeDelaySeconds)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getWhitelist: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("whitelist", whitelist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointResponse
  ) extends zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val authorization
        : Option[zio.aws.mediapackage.model.Authorization.ReadOnly] = scala
      .Option(impl.authorization())
      .map(value => zio.aws.mediapackage.model.Authorization.wrap(value))
    override val channelId: Option[__string] = scala
      .Option(impl.channelId())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val cmafPackage
        : Option[zio.aws.mediapackage.model.CmafPackage.ReadOnly] = scala
      .Option(impl.cmafPackage())
      .map(value => zio.aws.mediapackage.model.CmafPackage.wrap(value))
    override val dashPackage
        : Option[zio.aws.mediapackage.model.DashPackage.ReadOnly] = scala
      .Option(impl.dashPackage())
      .map(value => zio.aws.mediapackage.model.DashPackage.wrap(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val hlsPackage
        : Option[zio.aws.mediapackage.model.HlsPackage.ReadOnly] = scala
      .Option(impl.hlsPackage())
      .map(value => zio.aws.mediapackage.model.HlsPackage.wrap(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val manifestName: Option[__string] = scala
      .Option(impl.manifestName())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val mssPackage
        : Option[zio.aws.mediapackage.model.MssPackage.ReadOnly] = scala
      .Option(impl.mssPackage())
      .map(value => zio.aws.mediapackage.model.MssPackage.wrap(value))
    override val origination: Option[zio.aws.mediapackage.model.Origination] =
      scala
        .Option(impl.origination())
        .map(value => zio.aws.mediapackage.model.Origination.wrap(value))
    override val startoverWindowSeconds: Option[__integer] = scala
      .Option(impl.startoverWindowSeconds())
      .map(value => zio.aws.mediapackage.model.primitives.__integer(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediapackage.model.primitives.__string(
              key
            ) -> zio.aws.mediapackage.model.primitives.__string(value)
          })
          .toMap
      )
    override val timeDelaySeconds: Option[__integer] = scala
      .Option(impl.timeDelaySeconds())
      .map(value => zio.aws.mediapackage.model.primitives.__integer(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val whitelist: Option[List[__string]] = scala
      .Option(impl.whitelist())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointResponse
  ): zio.aws.mediapackage.model.CreateOriginEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
