package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOriginEndpointsResponse(
    nextToken: Option[__string] = None,
    originEndpoints: Option[
      Iterable[zio.aws.mediapackage.model.OriginEndpoint]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse = {
    import ListOriginEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        originEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.originEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly =
    zio.aws.mediapackage.model.ListOriginEndpointsResponse.wrap(buildAwsValue())
}
object ListOriginEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ListOriginEndpointsResponse =
      zio.aws.mediapackage.model.ListOriginEndpointsResponse(
        nextToken.map(value => value),
        originEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def originEndpoints
        : Option[List[zio.aws.mediapackage.model.OriginEndpoint.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOriginEndpoints: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.OriginEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("originEndpoints", originEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse
  ) extends zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val originEndpoints
        : Option[List[zio.aws.mediapackage.model.OriginEndpoint.ReadOnly]] =
      scala
        .Option(impl.originEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.OriginEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse
  ): zio.aws.mediapackage.model.ListOriginEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
