package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IngestEndpoint(
    id: Option[__string] = None,
    password: Option[__string] = None,
    url: Option[__string] = None,
    username: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.IngestEndpoint = {
    import IngestEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
      .builder()
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        password.map(value => __string.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        username.map(value => __string.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.IngestEndpoint.ReadOnly =
    zio.aws.mediapackage.model.IngestEndpoint.wrap(buildAwsValue())
}
object IngestEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.IngestEndpoint =
      zio.aws.mediapackage.model.IngestEndpoint(
        id.map(value => value),
        password.map(value => value),
        url.map(value => value),
        username.map(value => value)
      )
    def id: Option[__string]
    def password: Option[__string]
    def url: Option[__string]
    def username: Option[__string]
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getPassword: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("password", password)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getUsername: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
  ) extends zio.aws.mediapackage.model.IngestEndpoint.ReadOnly {
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val password: Option[__string] = scala
      .Option(impl.password())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val username: Option[__string] = scala
      .Option(impl.username())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
  ): zio.aws.mediapackage.model.IngestEndpoint.ReadOnly = new Wrapper(impl)
}
