package zio.aws.mediapackage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MssEncryption(
    spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.MssEncryption = {
    import MssEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.MssEncryption
      .builder()
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.MssEncryption.ReadOnly =
    zio.aws.mediapackage.model.MssEncryption.wrap(buildAwsValue())
}
object MssEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.MssEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.MssEncryption =
      zio.aws.mediapackage.model.MssEncryption(spekeKeyProvider.asEditable)
    def spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.MssEncryption
  ) extends zio.aws.mediapackage.model.MssEncryption.ReadOnly {
    override val spekeKeyProvider
        : zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackage.model.SpekeKeyProvider.wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.MssEncryption
  ): zio.aws.mediapackage.model.MssEncryption.ReadOnly = new Wrapper(impl)
}
