package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeHarvestJobResponse(
    arn: Option[__string] = None,
    channelId: Option[__string] = None,
    createdAt: Option[__string] = None,
    endTime: Option[__string] = None,
    id: Option[__string] = None,
    originEndpointId: Option[__string] = None,
    s3Destination: Option[zio.aws.mediapackage.model.S3Destination] = None,
    startTime: Option[__string] = None,
    status: Option[zio.aws.mediapackage.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse = {
    import DescribeHarvestJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        channelId.map(value => __string.unwrap(value): java.lang.String)
      )(_.channelId)
      .optionallyWith(
        createdAt.map(value => __string.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        endTime.map(value => __string.unwrap(value): java.lang.String)
      )(_.endTime)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        originEndpointId.map(value => __string.unwrap(value): java.lang.String)
      )(_.originEndpointId)
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .optionallyWith(
        startTime.map(value => __string.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly =
    zio.aws.mediapackage.model.DescribeHarvestJobResponse.wrap(buildAwsValue())
}
object DescribeHarvestJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DescribeHarvestJobResponse =
      zio.aws.mediapackage.model.DescribeHarvestJobResponse(
        arn.map(value => value),
        channelId.map(value => value),
        createdAt.map(value => value),
        endTime.map(value => value),
        id.map(value => value),
        originEndpointId.map(value => value),
        s3Destination.map(value => value.asEditable),
        startTime.map(value => value),
        status.map(value => value)
      )
    def arn: Option[__string]
    def channelId: Option[__string]
    def createdAt: Option[__string]
    def endTime: Option[__string]
    def id: Option[__string]
    def originEndpointId: Option[__string]
    def s3Destination: Option[zio.aws.mediapackage.model.S3Destination.ReadOnly]
    def startTime: Option[__string]
    def status: Option[zio.aws.mediapackage.model.Status]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEndTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getOriginEndpointId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originEndpointId", originEndpointId)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.S3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
    def getStartTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.mediapackage.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
  ) extends zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val channelId: Option[__string] = scala
      .Option(impl.channelId())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val createdAt: Option[__string] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val endTime: Option[__string] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val originEndpointId: Option[__string] = scala
      .Option(impl.originEndpointId())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val s3Destination
        : Option[zio.aws.mediapackage.model.S3Destination.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.mediapackage.model.S3Destination.wrap(value))
    override val startTime: Option[__string] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val status: Option[zio.aws.mediapackage.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.mediapackage.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
  ): zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly =
    new Wrapper(impl)
}
