package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait StreamOrder {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.StreamOrder
}
object StreamOrder {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.StreamOrder
  ): zio.aws.mediapackage.model.StreamOrder = value match {
    case software.amazon.awssdk.services.mediapackage.model.StreamOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.StreamOrder.ORIGINAL =>
      val r = ORIGINAL
      r
    case software.amazon.awssdk.services.mediapackage.model.StreamOrder.VIDEO_BITRATE_ASCENDING =>
      val r = VIDEO_BITRATE_ASCENDING
      r
    case software.amazon.awssdk.services.mediapackage.model.StreamOrder.VIDEO_BITRATE_DESCENDING =>
      val r = VIDEO_BITRATE_DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.StreamOrder {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.StreamOrder =
      software.amazon.awssdk.services.mediapackage.model.StreamOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ORIGINAL extends zio.aws.mediapackage.model.StreamOrder {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.StreamOrder =
      software.amazon.awssdk.services.mediapackage.model.StreamOrder.ORIGINAL
  }
  case object VIDEO_BITRATE_ASCENDING
      extends zio.aws.mediapackage.model.StreamOrder {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.StreamOrder =
      software.amazon.awssdk.services.mediapackage.model.StreamOrder.VIDEO_BITRATE_ASCENDING
  }
  case object VIDEO_BITRATE_DESCENDING
      extends zio.aws.mediapackage.model.StreamOrder {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.StreamOrder =
      software.amazon.awssdk.services.mediapackage.model.StreamOrder.VIDEO_BITRATE_DESCENDING
  }
}
