package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait AdMarkers {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.AdMarkers
}
object AdMarkers {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.AdMarkers
  ): zio.aws.mediapackage.model.AdMarkers = value match {
    case software.amazon.awssdk.services.mediapackage.model.AdMarkers.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.AdMarkers.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackage.model.AdMarkers.SCTE35_ENHANCED =>
      val r = SCTE35_ENHANCED
      r
    case software.amazon.awssdk.services.mediapackage.model.AdMarkers.PASSTHROUGH =>
      val r = PASSTHROUGH
      r
    case software.amazon.awssdk.services.mediapackage.model.AdMarkers.DATERANGE =>
      val r = DATERANGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediapackage.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdMarkers =
      software.amazon.awssdk.services.mediapackage.model.AdMarkers.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.mediapackage.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdMarkers =
      software.amazon.awssdk.services.mediapackage.model.AdMarkers.NONE
  }
  case object SCTE35_ENHANCED extends zio.aws.mediapackage.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdMarkers =
      software.amazon.awssdk.services.mediapackage.model.AdMarkers.SCTE35_ENHANCED
  }
  case object PASSTHROUGH extends zio.aws.mediapackage.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdMarkers =
      software.amazon.awssdk.services.mediapackage.model.AdMarkers.PASSTHROUGH
  }
  case object DATERANGE extends zio.aws.mediapackage.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdMarkers =
      software.amazon.awssdk.services.mediapackage.model.AdMarkers.DATERANGE
  }
}
