package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EgressAccessLogs(
    logGroupName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs = {
    import EgressAccessLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs
      .builder()
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly =
    zio.aws.mediapackage.model.EgressAccessLogs.wrap(buildAwsValue())
}
object EgressAccessLogs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.EgressAccessLogs =
      zio.aws.mediapackage.model
        .EgressAccessLogs(logGroupName.map(value => value))
    def logGroupName: Optional[__string]
    def getLogGroupName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs
  ) extends zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly {
    override val logGroupName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.EgressAccessLogs
  ): zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly = new Wrapper(impl)
}
