package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.{__boolean, __integer, __string}
import scala.jdk.CollectionConverters._
final case class HlsEncryption(
    constantInitializationVector: Optional[__string] = Optional.Absent,
    encryptionMethod: Optional[zio.aws.mediapackage.model.EncryptionMethod] =
      Optional.Absent,
    keyRotationIntervalSeconds: Optional[__integer] = Optional.Absent,
    repeatExtXKey: Optional[__boolean] = Optional.Absent,
    spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsEncryption = {
    import HlsEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsEncryption
      .builder()
      .optionallyWith(
        constantInitializationVector.map(value => value: java.lang.String)
      )(_.constantInitializationVector)
      .optionallyWith(encryptionMethod.map(value => value.unwrap))(
        _.encryptionMethod
      )
      .optionallyWith(keyRotationIntervalSeconds.map(value => value: Integer))(
        _.keyRotationIntervalSeconds
      )
      .optionallyWith(repeatExtXKey.map(value => value: java.lang.Boolean))(
        _.repeatExtXKey
      )
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.HlsEncryption.ReadOnly =
    zio.aws.mediapackage.model.HlsEncryption.wrap(buildAwsValue())
}
object HlsEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.HlsEncryption =
      zio.aws.mediapackage.model.HlsEncryption(
        constantInitializationVector.map(value => value),
        encryptionMethod.map(value => value),
        keyRotationIntervalSeconds.map(value => value),
        repeatExtXKey.map(value => value),
        spekeKeyProvider.asEditable
      )
    def constantInitializationVector: Optional[__string]
    def encryptionMethod: Optional[zio.aws.mediapackage.model.EncryptionMethod]
    def keyRotationIntervalSeconds: Optional[__integer]
    def repeatExtXKey: Optional[__boolean]
    def spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    def getConstantInitializationVector: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "constantInitializationVector",
        constantInitializationVector
      )
    def getEncryptionMethod
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.EncryptionMethod] =
      AwsError.unwrapOptionField("encryptionMethod", encryptionMethod)
    def getKeyRotationIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "keyRotationIntervalSeconds",
        keyRotationIntervalSeconds
      )
    def getRepeatExtXKey: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("repeatExtXKey", repeatExtXKey)
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsEncryption
  ) extends zio.aws.mediapackage.model.HlsEncryption.ReadOnly {
    override val constantInitializationVector: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constantInitializationVector())
        .map(value => value: __string)
    override val encryptionMethod
        : Optional[zio.aws.mediapackage.model.EncryptionMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMethod())
        .map(value => zio.aws.mediapackage.model.EncryptionMethod.wrap(value))
    override val keyRotationIntervalSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyRotationIntervalSeconds())
        .map(value => value: __integer)
    override val repeatExtXKey: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.repeatExtXKey())
      .map(value => value: __boolean)
    override val spekeKeyProvider
        : zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackage.model.SpekeKeyProvider.wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsEncryption
  ): zio.aws.mediapackage.model.HlsEncryption.ReadOnly = new Wrapper(impl)
}
