package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait SegmentTemplateFormat {
  def unwrap
      : software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat
}
object SegmentTemplateFormat {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat
  ): zio.aws.mediapackage.model.SegmentTemplateFormat = value match {
    case software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.NUMBER_WITH_TIMELINE =>
      val r = NUMBER_WITH_TIMELINE
      r
    case software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.TIME_WITH_TIMELINE =>
      val r = TIME_WITH_TIMELINE
      r
    case software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.NUMBER_WITH_DURATION =>
      val r = NUMBER_WITH_DURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object NUMBER_WITH_TIMELINE
      extends zio.aws.mediapackage.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.NUMBER_WITH_TIMELINE
  }
  case object TIME_WITH_TIMELINE
      extends zio.aws.mediapackage.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.TIME_WITH_TIMELINE
  }
  case object NUMBER_WITH_DURATION
      extends zio.aws.mediapackage.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat.NUMBER_WITH_DURATION
  }
}
