package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait PeriodTriggersElement {
  def unwrap
      : software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement
}
object PeriodTriggersElement {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement
  ): zio.aws.mediapackage.model.PeriodTriggersElement = value match {
    case software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement.ADS =>
      val r = ADS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.PeriodTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement.UNKNOWN_TO_SDK_VERSION
  }
  case object ADS extends zio.aws.mediapackage.model.PeriodTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement.ADS
  }
}
