package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait AdsOnDeliveryRestrictions {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions
}
object AdsOnDeliveryRestrictions {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions
  ): zio.aws.mediapackage.model.AdsOnDeliveryRestrictions = value match {
    case software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.RESTRICTED =>
      val r = RESTRICTED
      r
    case software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.UNRESTRICTED =>
      val r = UNRESTRICTED
      r
    case software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.BOTH =>
      val r = BOTH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.AdsOnDeliveryRestrictions {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions =
      software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE
      extends zio.aws.mediapackage.model.AdsOnDeliveryRestrictions {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions =
      software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.NONE
  }
  case object RESTRICTED
      extends zio.aws.mediapackage.model.AdsOnDeliveryRestrictions {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions =
      software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.RESTRICTED
  }
  case object UNRESTRICTED
      extends zio.aws.mediapackage.model.AdsOnDeliveryRestrictions {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions =
      software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.UNRESTRICTED
  }
  case object BOTH
      extends zio.aws.mediapackage.model.AdsOnDeliveryRestrictions {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions =
      software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions.BOTH
  }
}
