package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait UtcTiming {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.UtcTiming
}
object UtcTiming {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.UtcTiming
  ): zio.aws.mediapackage.model.UtcTiming = value match {
    case software.amazon.awssdk.services.mediapackage.model.UtcTiming.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.UtcTiming.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackage.model.UtcTiming.HTTP_HEAD =>
      val r = `HTTP-HEAD`
      r
    case software.amazon.awssdk.services.mediapackage.model.UtcTiming.HTTP_ISO =>
      val r = `HTTP-ISO`
      r
    case software.amazon.awssdk.services.mediapackage.model.UtcTiming.HTTP_XSDATE =>
      val r = `HTTP-XSDATE`
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediapackage.model.UtcTiming {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.UtcTiming =
      software.amazon.awssdk.services.mediapackage.model.UtcTiming.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.mediapackage.model.UtcTiming {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.UtcTiming =
      software.amazon.awssdk.services.mediapackage.model.UtcTiming.NONE
  }
  case object `HTTP-HEAD` extends zio.aws.mediapackage.model.UtcTiming {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.UtcTiming =
      software.amazon.awssdk.services.mediapackage.model.UtcTiming.HTTP_HEAD
  }
  case object `HTTP-ISO` extends zio.aws.mediapackage.model.UtcTiming {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.UtcTiming =
      software.amazon.awssdk.services.mediapackage.model.UtcTiming.HTTP_ISO
  }
  case object `HTTP-XSDATE` extends zio.aws.mediapackage.model.UtcTiming {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.UtcTiming =
      software.amazon.awssdk.services.mediapackage.model.UtcTiming.HTTP_XSDATE
  }
}
