package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait PlaylistType {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.PlaylistType
}
object PlaylistType {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.PlaylistType
  ): zio.aws.mediapackage.model.PlaylistType = value match {
    case software.amazon.awssdk.services.mediapackage.model.PlaylistType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.PlaylistType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackage.model.PlaylistType.EVENT =>
      val r = EVENT
      r
    case software.amazon.awssdk.services.mediapackage.model.PlaylistType.VOD =>
      val r = VOD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.PlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PlaylistType =
      software.amazon.awssdk.services.mediapackage.model.PlaylistType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.mediapackage.model.PlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PlaylistType =
      software.amazon.awssdk.services.mediapackage.model.PlaylistType.NONE
  }
  case object EVENT extends zio.aws.mediapackage.model.PlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PlaylistType =
      software.amazon.awssdk.services.mediapackage.model.PlaylistType.EVENT
  }
  case object VOD extends zio.aws.mediapackage.model.PlaylistType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PlaylistType =
      software.amazon.awssdk.services.mediapackage.model.PlaylistType.VOD
  }
}
