package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait ManifestLayout {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.ManifestLayout
}
object ManifestLayout {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.ManifestLayout
  ): zio.aws.mediapackage.model.ManifestLayout = value match {
    case software.amazon.awssdk.services.mediapackage.model.ManifestLayout.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.ManifestLayout.FULL =>
      val r = FULL
      r
    case software.amazon.awssdk.services.mediapackage.model.ManifestLayout.COMPACT =>
      val r = COMPACT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.ManifestLayout {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.ManifestLayout =
      software.amazon.awssdk.services.mediapackage.model.ManifestLayout.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.mediapackage.model.ManifestLayout {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.ManifestLayout =
      software.amazon.awssdk.services.mediapackage.model.ManifestLayout.FULL
  }
  case object COMPACT extends zio.aws.mediapackage.model.ManifestLayout {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.ManifestLayout =
      software.amazon.awssdk.services.mediapackage.model.ManifestLayout.COMPACT
  }
}
