package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class OriginEndpoint(
    arn: Optional[__string] = Optional.Absent,
    authorization: Optional[zio.aws.mediapackage.model.Authorization] =
      Optional.Absent,
    channelId: Optional[__string] = Optional.Absent,
    cmafPackage: Optional[zio.aws.mediapackage.model.CmafPackage] =
      Optional.Absent,
    dashPackage: Optional[zio.aws.mediapackage.model.DashPackage] =
      Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    hlsPackage: Optional[zio.aws.mediapackage.model.HlsPackage] =
      Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    manifestName: Optional[__string] = Optional.Absent,
    mssPackage: Optional[zio.aws.mediapackage.model.MssPackage] =
      Optional.Absent,
    origination: Optional[zio.aws.mediapackage.model.Origination] =
      Optional.Absent,
    startoverWindowSeconds: Optional[__integer] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    timeDelaySeconds: Optional[__integer] = Optional.Absent,
    url: Optional[__string] = Optional.Absent,
    whitelist: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.OriginEndpoint = {
    import OriginEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.OriginEndpoint
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .optionallyWith(origination.map(value => value.unwrap))(_.origination)
      .optionallyWith(startoverWindowSeconds.map(value => value: Integer))(
        _.startoverWindowSeconds
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(timeDelaySeconds.map(value => value: Integer))(
        _.timeDelaySeconds
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(
        whitelist.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.whitelist)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.OriginEndpoint.ReadOnly =
    zio.aws.mediapackage.model.OriginEndpoint.wrap(buildAwsValue())
}
object OriginEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.OriginEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.OriginEndpoint =
      zio.aws.mediapackage.model.OriginEndpoint(
        arn.map(value => value),
        authorization.map(value => value.asEditable),
        channelId.map(value => value),
        cmafPackage.map(value => value.asEditable),
        dashPackage.map(value => value.asEditable),
        description.map(value => value),
        hlsPackage.map(value => value.asEditable),
        id.map(value => value),
        manifestName.map(value => value),
        mssPackage.map(value => value.asEditable),
        origination.map(value => value),
        startoverWindowSeconds.map(value => value),
        tags.map(value => value),
        timeDelaySeconds.map(value => value),
        url.map(value => value),
        whitelist.map(value => value)
      )
    def arn: Optional[__string]
    def authorization
        : Optional[zio.aws.mediapackage.model.Authorization.ReadOnly]
    def channelId: Optional[__string]
    def cmafPackage: Optional[zio.aws.mediapackage.model.CmafPackage.ReadOnly]
    def dashPackage: Optional[zio.aws.mediapackage.model.DashPackage.ReadOnly]
    def description: Optional[__string]
    def hlsPackage: Optional[zio.aws.mediapackage.model.HlsPackage.ReadOnly]
    def id: Optional[__string]
    def manifestName: Optional[__string]
    def mssPackage: Optional[zio.aws.mediapackage.model.MssPackage.ReadOnly]
    def origination: Optional[zio.aws.mediapackage.model.Origination]
    def startoverWindowSeconds: Optional[__integer]
    def tags: Optional[Map[__string, __string]]
    def timeDelaySeconds: Optional[__integer]
    def url: Optional[__string]
    def whitelist: Optional[List[__string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getCmafPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.CmafPackage.ReadOnly] =
      AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getDashPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.DashPackage.ReadOnly] =
      AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHlsPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.HlsPackage.ReadOnly] =
      AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getMssPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.MssPackage.ReadOnly] =
      AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.Origination] =
      AwsError.unwrapOptionField("origination", origination)
    def getStartoverWindowSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("startoverWindowSeconds", startoverWindowSeconds)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTimeDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeDelaySeconds", timeDelaySeconds)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getWhitelist: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("whitelist", whitelist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.OriginEndpoint
  ) extends zio.aws.mediapackage.model.OriginEndpoint.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val authorization
        : Optional[zio.aws.mediapackage.model.Authorization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorization())
        .map(value => zio.aws.mediapackage.model.Authorization.wrap(value))
    override val channelId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.channelId())
      .map(value => value: __string)
    override val cmafPackage
        : Optional[zio.aws.mediapackage.model.CmafPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cmafPackage())
        .map(value => zio.aws.mediapackage.model.CmafPackage.wrap(value))
    override val dashPackage
        : Optional[zio.aws.mediapackage.model.DashPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashPackage())
        .map(value => zio.aws.mediapackage.model.DashPackage.wrap(value))
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val hlsPackage
        : Optional[zio.aws.mediapackage.model.HlsPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hlsPackage())
        .map(value => zio.aws.mediapackage.model.HlsPackage.wrap(value))
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val manifestName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.manifestName())
      .map(value => value: __string)
    override val mssPackage
        : Optional[zio.aws.mediapackage.model.MssPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mssPackage())
        .map(value => zio.aws.mediapackage.model.MssPackage.wrap(value))
    override val origination: Optional[zio.aws.mediapackage.model.Origination] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origination())
        .map(value => zio.aws.mediapackage.model.Origination.wrap(value))
    override val startoverWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startoverWindowSeconds())
        .map(value => value: __integer)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val timeDelaySeconds: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeDelaySeconds())
      .map(value => value: __integer)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
    override val whitelist: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.whitelist())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.OriginEndpoint
  ): zio.aws.mediapackage.model.OriginEndpoint.ReadOnly = new Wrapper(impl)
}
