package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Authorization(
    cdnIdentifierSecret: __string,
    secretsRoleArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.Authorization = {
    import Authorization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.Authorization
      .builder()
      .cdnIdentifierSecret(cdnIdentifierSecret: java.lang.String)
      .secretsRoleArn(secretsRoleArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.Authorization.ReadOnly =
    zio.aws.mediapackage.model.Authorization.wrap(buildAwsValue())
}
object Authorization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.Authorization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.Authorization =
      zio.aws.mediapackage.model
        .Authorization(cdnIdentifierSecret, secretsRoleArn)
    def cdnIdentifierSecret: __string
    def secretsRoleArn: __string
    def getCdnIdentifierSecret: ZIO[Any, Nothing, __string] =
      ZIO.succeed(cdnIdentifierSecret)
    def getSecretsRoleArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(secretsRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.Authorization
  ) extends zio.aws.mediapackage.model.Authorization.ReadOnly {
    override val cdnIdentifierSecret: __string =
      impl.cdnIdentifierSecret(): __string
    override val secretsRoleArn: __string = impl.secretsRoleArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.Authorization
  ): zio.aws.mediapackage.model.Authorization.ReadOnly = new Wrapper(impl)
}
