package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters._
final case class CmafPackageCreateOrUpdateParameters(
    encryption: Optional[zio.aws.mediapackage.model.CmafEncryption] =
      Optional.Absent,
    hlsManifests: Optional[
      Iterable[zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters]
    ] = Optional.Absent,
    segmentDurationSeconds: Optional[__integer] = Optional.Absent,
    segmentPrefix: Optional[__string] = Optional.Absent,
    streamSelection: Optional[zio.aws.mediapackage.model.StreamSelection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CmafPackageCreateOrUpdateParameters = {
    import CmafPackageCreateOrUpdateParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CmafPackageCreateOrUpdateParameters
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        hlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hlsManifests)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(segmentPrefix.map(value => value: java.lang.String))(
        _.segmentPrefix
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly =
    zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters
      .wrap(buildAwsValue())
}
object CmafPackageCreateOrUpdateParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CmafPackageCreateOrUpdateParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters =
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters(
        encryption.map(value => value.asEditable),
        hlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        segmentDurationSeconds.map(value => value),
        segmentPrefix.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def encryption: Optional[zio.aws.mediapackage.model.CmafEncryption.ReadOnly]
    def hlsManifests: Optional[List[
      zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters.ReadOnly
    ]]
    def segmentDurationSeconds: Optional[__integer]
    def segmentPrefix: Optional[__string]
    def streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.CmafEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters.ReadOnly
    ]] = AwsError.unwrapOptionField("hlsManifests", hlsManifests)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentPrefix", segmentPrefix)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CmafPackageCreateOrUpdateParameters
  ) extends zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly {
    override val encryption
        : Optional[zio.aws.mediapackage.model.CmafEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.mediapackage.model.CmafEncryption.wrap(value))
    override val hlsManifests: Optional[List[
      zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.HlsManifestCreateOrUpdateParameters
            .wrap(item)
        }.toList
      )
    override val segmentDurationSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentDurationSeconds())
        .map(value => value: __integer)
    override val segmentPrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentPrefix())
      .map(value => value: __string)
    override val streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSelection())
        .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CmafPackageCreateOrUpdateParameters
  ): zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly =
    new Wrapper(impl)
}
