package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait Origination {
  def unwrap: software.amazon.awssdk.services.mediapackage.model.Origination
}
object Origination {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.Origination
  ): zio.aws.mediapackage.model.Origination = value match {
    case software.amazon.awssdk.services.mediapackage.model.Origination.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.Origination.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.mediapackage.model.Origination.DENY =>
      val r = DENY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.Origination {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Origination =
      software.amazon.awssdk.services.mediapackage.model.Origination.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.mediapackage.model.Origination {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Origination =
      software.amazon.awssdk.services.mediapackage.model.Origination.ALLOW
  }
  case object DENY extends zio.aws.mediapackage.model.Origination {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.Origination =
      software.amazon.awssdk.services.mediapackage.model.Origination.DENY
  }
}
