package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.__integer
import scala.jdk.CollectionConverters._
final case class MssPackage(
    encryption: Optional[zio.aws.mediapackage.model.MssEncryption] =
      Optional.Absent,
    manifestWindowSeconds: Optional[__integer] = Optional.Absent,
    segmentDurationSeconds: Optional[__integer] = Optional.Absent,
    streamSelection: Optional[zio.aws.mediapackage.model.StreamSelection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.MssPackage = {
    import MssPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.MssPackage
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(manifestWindowSeconds.map(value => value: Integer))(
        _.manifestWindowSeconds
      )
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.MssPackage.ReadOnly =
    zio.aws.mediapackage.model.MssPackage.wrap(buildAwsValue())
}
object MssPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.MssPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.MssPackage =
      zio.aws.mediapackage.model.MssPackage(
        encryption.map(value => value.asEditable),
        manifestWindowSeconds.map(value => value),
        segmentDurationSeconds.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def encryption: Optional[zio.aws.mediapackage.model.MssEncryption.ReadOnly]
    def manifestWindowSeconds: Optional[__integer]
    def segmentDurationSeconds: Optional[__integer]
    def streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.MssEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.MssPackage
  ) extends zio.aws.mediapackage.model.MssPackage.ReadOnly {
    override val encryption
        : Optional[zio.aws.mediapackage.model.MssEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.mediapackage.model.MssEncryption.wrap(value))
    override val manifestWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestWindowSeconds())
        .map(value => value: __integer)
    override val segmentDurationSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentDurationSeconds())
        .map(value => value: __integer)
    override val streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSelection())
        .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.MssPackage
  ): zio.aws.mediapackage.model.MssPackage.ReadOnly = new Wrapper(impl)
}
