package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__string, __integer}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DashPackage(
    adTriggers: Option[Iterable[zio.aws.mediapackage.model.AdTriggersElement]] =
      None,
    adsOnDeliveryRestrictions: Option[
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = None,
    encryption: Option[zio.aws.mediapackage.model.DashEncryption] = None,
    manifestLayout: Option[zio.aws.mediapackage.model.ManifestLayout] = None,
    manifestWindowSeconds: Option[__integer] = None,
    minBufferTimeSeconds: Option[__integer] = None,
    minUpdatePeriodSeconds: Option[__integer] = None,
    periodTriggers: Option[
      Iterable[zio.aws.mediapackage.model.PeriodTriggersElement]
    ] = None,
    profile: Option[zio.aws.mediapackage.model.Profile] = None,
    segmentDurationSeconds: Option[__integer] = None,
    segmentTemplateFormat: Option[
      zio.aws.mediapackage.model.SegmentTemplateFormat
    ] = None,
    streamSelection: Option[zio.aws.mediapackage.model.StreamSelection] = None,
    suggestedPresentationDelaySeconds: Option[__integer] = None,
    utcTiming: Option[zio.aws.mediapackage.model.UtcTiming] = None,
    utcTimingUri: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DashPackage = {
    import DashPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DashPackage
      .builder()
      .optionallyWith(
        adTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adTriggersWithStrings)
      .optionallyWith(adsOnDeliveryRestrictions.map(value => value.unwrap))(
        _.adsOnDeliveryRestrictions
      )
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(manifestLayout.map(value => value.unwrap))(
        _.manifestLayout
      )
      .optionallyWith(manifestWindowSeconds.map(value => value: Integer))(
        _.manifestWindowSeconds
      )
      .optionallyWith(minBufferTimeSeconds.map(value => value: Integer))(
        _.minBufferTimeSeconds
      )
      .optionallyWith(minUpdatePeriodSeconds.map(value => value: Integer))(
        _.minUpdatePeriodSeconds
      )
      .optionallyWith(
        periodTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.periodTriggersWithStrings)
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(segmentTemplateFormat.map(value => value.unwrap))(
        _.segmentTemplateFormat
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .optionallyWith(
        suggestedPresentationDelaySeconds.map(value => value: Integer)
      )(_.suggestedPresentationDelaySeconds)
      .optionallyWith(utcTiming.map(value => value.unwrap))(_.utcTiming)
      .optionallyWith(utcTimingUri.map(value => value: java.lang.String))(
        _.utcTimingUri
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.DashPackage.ReadOnly =
    zio.aws.mediapackage.model.DashPackage.wrap(buildAwsValue())
}
object DashPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DashPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DashPackage =
      zio.aws.mediapackage.model.DashPackage(
        adTriggers.map(value => value),
        adsOnDeliveryRestrictions.map(value => value),
        encryption.map(value => value.asEditable),
        manifestLayout.map(value => value),
        manifestWindowSeconds.map(value => value),
        minBufferTimeSeconds.map(value => value),
        minUpdatePeriodSeconds.map(value => value),
        periodTriggers.map(value => value),
        profile.map(value => value),
        segmentDurationSeconds.map(value => value),
        segmentTemplateFormat.map(value => value),
        streamSelection.map(value => value.asEditable),
        suggestedPresentationDelaySeconds.map(value => value),
        utcTiming.map(value => value),
        utcTimingUri.map(value => value)
      )
    def adTriggers: Option[List[zio.aws.mediapackage.model.AdTriggersElement]]
    def adsOnDeliveryRestrictions
        : Option[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions]
    def encryption: Option[zio.aws.mediapackage.model.DashEncryption.ReadOnly]
    def manifestLayout: Option[zio.aws.mediapackage.model.ManifestLayout]
    def manifestWindowSeconds: Option[__integer]
    def minBufferTimeSeconds: Option[__integer]
    def minUpdatePeriodSeconds: Option[__integer]
    def periodTriggers
        : Option[List[zio.aws.mediapackage.model.PeriodTriggersElement]]
    def profile: Option[zio.aws.mediapackage.model.Profile]
    def segmentDurationSeconds: Option[__integer]
    def segmentTemplateFormat
        : Option[zio.aws.mediapackage.model.SegmentTemplateFormat]
    def streamSelection
        : Option[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def suggestedPresentationDelaySeconds: Option[__integer]
    def utcTiming: Option[zio.aws.mediapackage.model.UtcTiming]
    def utcTimingUri: Option[__string]
    def getAdTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.AdTriggersElement
    ]] = AwsError.unwrapOptionField("adTriggers", adTriggers)
    def getAdsOnDeliveryRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = AwsError.unwrapOptionField(
      "adsOnDeliveryRestrictions",
      adsOnDeliveryRestrictions
    )
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.DashEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getManifestLayout
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.ManifestLayout] =
      AwsError.unwrapOptionField("manifestLayout", manifestLayout)
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getMinBufferTimeSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minBufferTimeSeconds", minBufferTimeSeconds)
    def getMinUpdatePeriodSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("minUpdatePeriodSeconds", minUpdatePeriodSeconds)
    def getPeriodTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.PeriodTriggersElement
    ]] = AwsError.unwrapOptionField("periodTriggers", periodTriggers)
    def getProfile: ZIO[Any, AwsError, zio.aws.mediapackage.model.Profile] =
      AwsError.unwrapOptionField("profile", profile)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentTemplateFormat
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.SegmentTemplateFormat] =
      AwsError.unwrapOptionField("segmentTemplateFormat", segmentTemplateFormat)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
    def getSuggestedPresentationDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "suggestedPresentationDelaySeconds",
        suggestedPresentationDelaySeconds
      )
    def getUtcTiming: ZIO[Any, AwsError, zio.aws.mediapackage.model.UtcTiming] =
      AwsError.unwrapOptionField("utcTiming", utcTiming)
    def getUtcTimingUri: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("utcTimingUri", utcTimingUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DashPackage
  ) extends zio.aws.mediapackage.model.DashPackage.ReadOnly {
    override val adTriggers
        : Option[List[zio.aws.mediapackage.model.AdTriggersElement]] = scala
      .Option(impl.adTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.AdTriggersElement.wrap(item)
        }.toList
      )
    override val adsOnDeliveryRestrictions
        : Option[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions] = scala
      .Option(impl.adsOnDeliveryRestrictions())
      .map(value =>
        zio.aws.mediapackage.model.AdsOnDeliveryRestrictions.wrap(value)
      )
    override val encryption
        : Option[zio.aws.mediapackage.model.DashEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackage.model.DashEncryption.wrap(value))
    override val manifestLayout
        : Option[zio.aws.mediapackage.model.ManifestLayout] = scala
      .Option(impl.manifestLayout())
      .map(value => zio.aws.mediapackage.model.ManifestLayout.wrap(value))
    override val manifestWindowSeconds: Option[__integer] =
      scala.Option(impl.manifestWindowSeconds()).map(value => value: __integer)
    override val minBufferTimeSeconds: Option[__integer] =
      scala.Option(impl.minBufferTimeSeconds()).map(value => value: __integer)
    override val minUpdatePeriodSeconds: Option[__integer] =
      scala.Option(impl.minUpdatePeriodSeconds()).map(value => value: __integer)
    override val periodTriggers
        : Option[List[zio.aws.mediapackage.model.PeriodTriggersElement]] = scala
      .Option(impl.periodTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.PeriodTriggersElement.wrap(item)
        }.toList
      )
    override val profile: Option[zio.aws.mediapackage.model.Profile] = scala
      .Option(impl.profile())
      .map(value => zio.aws.mediapackage.model.Profile.wrap(value))
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
    override val segmentTemplateFormat
        : Option[zio.aws.mediapackage.model.SegmentTemplateFormat] = scala
      .Option(impl.segmentTemplateFormat())
      .map(value =>
        zio.aws.mediapackage.model.SegmentTemplateFormat.wrap(value)
      )
    override val streamSelection
        : Option[zio.aws.mediapackage.model.StreamSelection.ReadOnly] = scala
      .Option(impl.streamSelection())
      .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
    override val suggestedPresentationDelaySeconds: Option[__integer] = scala
      .Option(impl.suggestedPresentationDelaySeconds())
      .map(value => value: __integer)
    override val utcTiming: Option[zio.aws.mediapackage.model.UtcTiming] = scala
      .Option(impl.utcTiming())
      .map(value => zio.aws.mediapackage.model.UtcTiming.wrap(value))
    override val utcTimingUri: Option[__string] =
      scala.Option(impl.utcTimingUri()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DashPackage
  ): zio.aws.mediapackage.model.DashPackage.ReadOnly = new Wrapper(impl)
}
