package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__string, __integer}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CmafPackage(
    encryption: Option[zio.aws.mediapackage.model.CmafEncryption] = None,
    hlsManifests: Option[Iterable[zio.aws.mediapackage.model.HlsManifest]] =
      None,
    segmentDurationSeconds: Option[__integer] = None,
    segmentPrefix: Option[__string] = None,
    streamSelection: Option[zio.aws.mediapackage.model.StreamSelection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CmafPackage = {
    import CmafPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CmafPackage
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        hlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hlsManifests)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(segmentPrefix.map(value => value: java.lang.String))(
        _.segmentPrefix
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.CmafPackage.ReadOnly =
    zio.aws.mediapackage.model.CmafPackage.wrap(buildAwsValue())
}
object CmafPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CmafPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CmafPackage =
      zio.aws.mediapackage.model.CmafPackage(
        encryption.map(value => value.asEditable),
        hlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        segmentDurationSeconds.map(value => value),
        segmentPrefix.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def encryption: Option[zio.aws.mediapackage.model.CmafEncryption.ReadOnly]
    def hlsManifests
        : Option[List[zio.aws.mediapackage.model.HlsManifest.ReadOnly]]
    def segmentDurationSeconds: Option[__integer]
    def segmentPrefix: Option[__string]
    def streamSelection
        : Option[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.CmafEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.HlsManifest.ReadOnly
    ]] = AwsError.unwrapOptionField("hlsManifests", hlsManifests)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentPrefix", segmentPrefix)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CmafPackage
  ) extends zio.aws.mediapackage.model.CmafPackage.ReadOnly {
    override val encryption
        : Option[zio.aws.mediapackage.model.CmafEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackage.model.CmafEncryption.wrap(value))
    override val hlsManifests
        : Option[List[zio.aws.mediapackage.model.HlsManifest.ReadOnly]] = scala
      .Option(impl.hlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.HlsManifest.wrap(item)
        }.toList
      )
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
    override val segmentPrefix: Option[__string] =
      scala.Option(impl.segmentPrefix()).map(value => value: __string)
    override val streamSelection
        : Option[zio.aws.mediapackage.model.StreamSelection.ReadOnly] = scala
      .Option(impl.streamSelection())
      .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CmafPackage
  ): zio.aws.mediapackage.model.CmafPackage.ReadOnly = new Wrapper(impl)
}
