package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{MaxResults, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListHarvestJobsRequest(
    includeChannelId: Option[__string] = None,
    includeStatus: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest = {
    import ListHarvestJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest
      .builder()
      .optionallyWith(includeChannelId.map(value => value: java.lang.String))(
        _.includeChannelId
      )
      .optionallyWith(includeStatus.map(value => value: java.lang.String))(
        _.includeStatus
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.ListHarvestJobsRequest.ReadOnly =
    zio.aws.mediapackage.model.ListHarvestJobsRequest.wrap(buildAwsValue())
}
object ListHarvestJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ListHarvestJobsRequest =
      zio.aws.mediapackage.model.ListHarvestJobsRequest(
        includeChannelId.map(value => value),
        includeStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def includeChannelId: Option[__string]
    def includeStatus: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getIncludeChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("includeChannelId", includeChannelId)
    def getIncludeStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("includeStatus", includeStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest
  ) extends zio.aws.mediapackage.model.ListHarvestJobsRequest.ReadOnly {
    override val includeChannelId: Option[__string] =
      scala.Option(impl.includeChannelId()).map(value => value: __string)
    override val includeStatus: Option[__string] =
      scala.Option(impl.includeStatus()).map(value => value: __string)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediapackage.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest
  ): zio.aws.mediapackage.model.ListHarvestJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
