package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IngressAccessLogs(logGroupName: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs = {
    import IngressAccessLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs
      .builder()
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly =
    zio.aws.mediapackage.model.IngressAccessLogs.wrap(buildAwsValue())
}
object IngressAccessLogs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.IngressAccessLogs =
      zio.aws.mediapackage.model
        .IngressAccessLogs(logGroupName.map(value => value))
    def logGroupName: Option[__string]
    def getLogGroupName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs
  ) extends zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly {
    override val logGroupName: Option[__string] =
      scala.Option(impl.logGroupName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.IngressAccessLogs
  ): zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly = new Wrapper(impl)
}
