package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__boolean, __integer, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HlsEncryption(
    constantInitializationVector: Option[__string] = None,
    encryptionMethod: Option[zio.aws.mediapackage.model.EncryptionMethod] =
      None,
    keyRotationIntervalSeconds: Option[__integer] = None,
    repeatExtXKey: Option[__boolean] = None,
    spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsEncryption = {
    import HlsEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsEncryption
      .builder()
      .optionallyWith(
        constantInitializationVector.map(value => value: java.lang.String)
      )(_.constantInitializationVector)
      .optionallyWith(encryptionMethod.map(value => value.unwrap))(
        _.encryptionMethod
      )
      .optionallyWith(keyRotationIntervalSeconds.map(value => value: Integer))(
        _.keyRotationIntervalSeconds
      )
      .optionallyWith(repeatExtXKey.map(value => value: java.lang.Boolean))(
        _.repeatExtXKey
      )
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.HlsEncryption.ReadOnly =
    zio.aws.mediapackage.model.HlsEncryption.wrap(buildAwsValue())
}
object HlsEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.HlsEncryption =
      zio.aws.mediapackage.model.HlsEncryption(
        constantInitializationVector.map(value => value),
        encryptionMethod.map(value => value),
        keyRotationIntervalSeconds.map(value => value),
        repeatExtXKey.map(value => value),
        spekeKeyProvider.asEditable
      )
    def constantInitializationVector: Option[__string]
    def encryptionMethod: Option[zio.aws.mediapackage.model.EncryptionMethod]
    def keyRotationIntervalSeconds: Option[__integer]
    def repeatExtXKey: Option[__boolean]
    def spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    def getConstantInitializationVector: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "constantInitializationVector",
        constantInitializationVector
      )
    def getEncryptionMethod
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.EncryptionMethod] =
      AwsError.unwrapOptionField("encryptionMethod", encryptionMethod)
    def getKeyRotationIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "keyRotationIntervalSeconds",
        keyRotationIntervalSeconds
      )
    def getRepeatExtXKey: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("repeatExtXKey", repeatExtXKey)
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsEncryption
  ) extends zio.aws.mediapackage.model.HlsEncryption.ReadOnly {
    override val constantInitializationVector: Option[__string] = scala
      .Option(impl.constantInitializationVector())
      .map(value => value: __string)
    override val encryptionMethod
        : Option[zio.aws.mediapackage.model.EncryptionMethod] = scala
      .Option(impl.encryptionMethod())
      .map(value => zio.aws.mediapackage.model.EncryptionMethod.wrap(value))
    override val keyRotationIntervalSeconds: Option[__integer] = scala
      .Option(impl.keyRotationIntervalSeconds())
      .map(value => value: __integer)
    override val repeatExtXKey: Option[__boolean] =
      scala.Option(impl.repeatExtXKey()).map(value => value: __boolean)
    override val spekeKeyProvider
        : zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackage.model.SpekeKeyProvider.wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsEncryption
  ): zio.aws.mediapackage.model.HlsEncryption.ReadOnly = new Wrapper(impl)
}
