package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__integer, __boolean}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HlsPackage(
    adMarkers: Option[zio.aws.mediapackage.model.AdMarkers] = None,
    adTriggers: Option[Iterable[zio.aws.mediapackage.model.AdTriggersElement]] =
      None,
    adsOnDeliveryRestrictions: Option[
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = None,
    encryption: Option[zio.aws.mediapackage.model.HlsEncryption] = None,
    includeDvbSubtitles: Option[__boolean] = None,
    includeIframeOnlyStream: Option[__boolean] = None,
    playlistType: Option[zio.aws.mediapackage.model.PlaylistType] = None,
    playlistWindowSeconds: Option[__integer] = None,
    programDateTimeIntervalSeconds: Option[__integer] = None,
    segmentDurationSeconds: Option[__integer] = None,
    streamSelection: Option[zio.aws.mediapackage.model.StreamSelection] = None,
    useAudioRenditionGroup: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsPackage = {
    import HlsPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsPackage
      .builder()
      .optionallyWith(adMarkers.map(value => value.unwrap))(_.adMarkers)
      .optionallyWith(
        adTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adTriggersWithStrings)
      .optionallyWith(adsOnDeliveryRestrictions.map(value => value.unwrap))(
        _.adsOnDeliveryRestrictions
      )
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        includeDvbSubtitles.map(value => value: java.lang.Boolean)
      )(_.includeDvbSubtitles)
      .optionallyWith(
        includeIframeOnlyStream.map(value => value: java.lang.Boolean)
      )(_.includeIframeOnlyStream)
      .optionallyWith(playlistType.map(value => value.unwrap))(_.playlistType)
      .optionallyWith(playlistWindowSeconds.map(value => value: Integer))(
        _.playlistWindowSeconds
      )
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value => value: Integer)
      )(_.programDateTimeIntervalSeconds)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .optionallyWith(
        useAudioRenditionGroup.map(value => value: java.lang.Boolean)
      )(_.useAudioRenditionGroup)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.HlsPackage.ReadOnly =
    zio.aws.mediapackage.model.HlsPackage.wrap(buildAwsValue())
}
object HlsPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.HlsPackage =
      zio.aws.mediapackage.model.HlsPackage(
        adMarkers.map(value => value),
        adTriggers.map(value => value),
        adsOnDeliveryRestrictions.map(value => value),
        encryption.map(value => value.asEditable),
        includeDvbSubtitles.map(value => value),
        includeIframeOnlyStream.map(value => value),
        playlistType.map(value => value),
        playlistWindowSeconds.map(value => value),
        programDateTimeIntervalSeconds.map(value => value),
        segmentDurationSeconds.map(value => value),
        streamSelection.map(value => value.asEditable),
        useAudioRenditionGroup.map(value => value)
      )
    def adMarkers: Option[zio.aws.mediapackage.model.AdMarkers]
    def adTriggers: Option[List[zio.aws.mediapackage.model.AdTriggersElement]]
    def adsOnDeliveryRestrictions
        : Option[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions]
    def encryption: Option[zio.aws.mediapackage.model.HlsEncryption.ReadOnly]
    def includeDvbSubtitles: Option[__boolean]
    def includeIframeOnlyStream: Option[__boolean]
    def playlistType: Option[zio.aws.mediapackage.model.PlaylistType]
    def playlistWindowSeconds: Option[__integer]
    def programDateTimeIntervalSeconds: Option[__integer]
    def segmentDurationSeconds: Option[__integer]
    def streamSelection
        : Option[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def useAudioRenditionGroup: Option[__boolean]
    def getAdMarkers: ZIO[Any, AwsError, zio.aws.mediapackage.model.AdMarkers] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getAdTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.AdTriggersElement
    ]] = AwsError.unwrapOptionField("adTriggers", adTriggers)
    def getAdsOnDeliveryRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = AwsError.unwrapOptionField(
      "adsOnDeliveryRestrictions",
      adsOnDeliveryRestrictions
    )
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.HlsEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getIncludeDvbSubtitles: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("includeDvbSubtitles", includeDvbSubtitles)
    def getIncludeIframeOnlyStream: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("includeIframeOnlyStream", includeIframeOnlyStream)
    def getPlaylistType
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.PlaylistType] =
      AwsError.unwrapOptionField("playlistType", playlistType)
    def getPlaylistWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("playlistWindowSeconds", playlistWindowSeconds)
    def getProgramDateTimeIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "programDateTimeIntervalSeconds",
        programDateTimeIntervalSeconds
      )
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
    def getUseAudioRenditionGroup: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("useAudioRenditionGroup", useAudioRenditionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsPackage
  ) extends zio.aws.mediapackage.model.HlsPackage.ReadOnly {
    override val adMarkers: Option[zio.aws.mediapackage.model.AdMarkers] = scala
      .Option(impl.adMarkers())
      .map(value => zio.aws.mediapackage.model.AdMarkers.wrap(value))
    override val adTriggers
        : Option[List[zio.aws.mediapackage.model.AdTriggersElement]] = scala
      .Option(impl.adTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackage.model.AdTriggersElement.wrap(item)
        }.toList
      )
    override val adsOnDeliveryRestrictions
        : Option[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions] = scala
      .Option(impl.adsOnDeliveryRestrictions())
      .map(value =>
        zio.aws.mediapackage.model.AdsOnDeliveryRestrictions.wrap(value)
      )
    override val encryption
        : Option[zio.aws.mediapackage.model.HlsEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackage.model.HlsEncryption.wrap(value))
    override val includeDvbSubtitles: Option[__boolean] =
      scala.Option(impl.includeDvbSubtitles()).map(value => value: __boolean)
    override val includeIframeOnlyStream: Option[__boolean] = scala
      .Option(impl.includeIframeOnlyStream())
      .map(value => value: __boolean)
    override val playlistType: Option[zio.aws.mediapackage.model.PlaylistType] =
      scala
        .Option(impl.playlistType())
        .map(value => zio.aws.mediapackage.model.PlaylistType.wrap(value))
    override val playlistWindowSeconds: Option[__integer] =
      scala.Option(impl.playlistWindowSeconds()).map(value => value: __integer)
    override val programDateTimeIntervalSeconds: Option[__integer] = scala
      .Option(impl.programDateTimeIntervalSeconds())
      .map(value => value: __integer)
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
    override val streamSelection
        : Option[zio.aws.mediapackage.model.StreamSelection.ReadOnly] = scala
      .Option(impl.streamSelection())
      .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
    override val useAudioRenditionGroup: Option[__boolean] =
      scala.Option(impl.useAudioRenditionGroup()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsPackage
  ): zio.aws.mediapackage.model.HlsPackage.ReadOnly = new Wrapper(impl)
}
