package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__integer
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamSelection(
    maxVideoBitsPerSecond: Option[__integer] = None,
    minVideoBitsPerSecond: Option[__integer] = None,
    streamOrder: Option[zio.aws.mediapackage.model.StreamOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.StreamSelection = {
    import StreamSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.StreamSelection
      .builder()
      .optionallyWith(maxVideoBitsPerSecond.map(value => value: Integer))(
        _.maxVideoBitsPerSecond
      )
      .optionallyWith(minVideoBitsPerSecond.map(value => value: Integer))(
        _.minVideoBitsPerSecond
      )
      .optionallyWith(streamOrder.map(value => value.unwrap))(_.streamOrder)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.StreamSelection.ReadOnly =
    zio.aws.mediapackage.model.StreamSelection.wrap(buildAwsValue())
}
object StreamSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.StreamSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.StreamSelection =
      zio.aws.mediapackage.model.StreamSelection(
        maxVideoBitsPerSecond.map(value => value),
        minVideoBitsPerSecond.map(value => value),
        streamOrder.map(value => value)
      )
    def maxVideoBitsPerSecond: Option[__integer]
    def minVideoBitsPerSecond: Option[__integer]
    def streamOrder: Option[zio.aws.mediapackage.model.StreamOrder]
    def getMaxVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxVideoBitsPerSecond", maxVideoBitsPerSecond)
    def getMinVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minVideoBitsPerSecond", minVideoBitsPerSecond)
    def getStreamOrder
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.StreamOrder] =
      AwsError.unwrapOptionField("streamOrder", streamOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.StreamSelection
  ) extends zio.aws.mediapackage.model.StreamSelection.ReadOnly {
    override val maxVideoBitsPerSecond: Option[__integer] =
      scala.Option(impl.maxVideoBitsPerSecond()).map(value => value: __integer)
    override val minVideoBitsPerSecond: Option[__integer] =
      scala.Option(impl.minVideoBitsPerSecond()).map(value => value: __integer)
    override val streamOrder: Option[zio.aws.mediapackage.model.StreamOrder] =
      scala
        .Option(impl.streamOrder())
        .map(value => zio.aws.mediapackage.model.StreamOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.StreamSelection
  ): zio.aws.mediapackage.model.StreamSelection.ReadOnly = new Wrapper(impl)
}
