package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.{__integer, __string}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateOriginEndpointRequest(
    authorization: Option[zio.aws.mediapackage.model.Authorization] = None,
    channelId: __string,
    cmafPackage: Option[
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters
    ] = None,
    dashPackage: Option[zio.aws.mediapackage.model.DashPackage] = None,
    description: Option[__string] = None,
    hlsPackage: Option[zio.aws.mediapackage.model.HlsPackage] = None,
    id: __string,
    manifestName: Option[__string] = None,
    mssPackage: Option[zio.aws.mediapackage.model.MssPackage] = None,
    origination: Option[zio.aws.mediapackage.model.Origination] = None,
    startoverWindowSeconds: Option[__integer] = None,
    tags: Option[Map[__string, __string]] = None,
    timeDelaySeconds: Option[__integer] = None,
    whitelist: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest = {
    import CreateOriginEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest
      .builder()
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .channelId(channelId: java.lang.String)
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .id(id: java.lang.String)
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .optionallyWith(origination.map(value => value.unwrap))(_.origination)
      .optionallyWith(startoverWindowSeconds.map(value => value: Integer))(
        _.startoverWindowSeconds
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(timeDelaySeconds.map(value => value: Integer))(
        _.timeDelaySeconds
      )
      .optionallyWith(
        whitelist.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.whitelist)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.CreateOriginEndpointRequest.ReadOnly =
    zio.aws.mediapackage.model.CreateOriginEndpointRequest.wrap(buildAwsValue())
}
object CreateOriginEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CreateOriginEndpointRequest =
      zio.aws.mediapackage.model.CreateOriginEndpointRequest(
        authorization.map(value => value.asEditable),
        channelId,
        cmafPackage.map(value => value.asEditable),
        dashPackage.map(value => value.asEditable),
        description.map(value => value),
        hlsPackage.map(value => value.asEditable),
        id,
        manifestName.map(value => value),
        mssPackage.map(value => value.asEditable),
        origination.map(value => value),
        startoverWindowSeconds.map(value => value),
        tags.map(value => value),
        timeDelaySeconds.map(value => value),
        whitelist.map(value => value)
      )
    def authorization: Option[zio.aws.mediapackage.model.Authorization.ReadOnly]
    def channelId: __string
    def cmafPackage: Option[
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly
    ]
    def dashPackage: Option[zio.aws.mediapackage.model.DashPackage.ReadOnly]
    def description: Option[__string]
    def hlsPackage: Option[zio.aws.mediapackage.model.HlsPackage.ReadOnly]
    def id: __string
    def manifestName: Option[__string]
    def mssPackage: Option[zio.aws.mediapackage.model.MssPackage.ReadOnly]
    def origination: Option[zio.aws.mediapackage.model.Origination]
    def startoverWindowSeconds: Option[__integer]
    def tags: Option[Map[__string, __string]]
    def timeDelaySeconds: Option[__integer]
    def whitelist: Option[List[__string]]
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getChannelId: ZIO[Any, Nothing, __string] = ZIO.succeed(channelId)
    def getCmafPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly
    ] = AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getDashPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.DashPackage.ReadOnly] =
      AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHlsPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.HlsPackage.ReadOnly] =
      AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getMssPackage
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.MssPackage.ReadOnly] =
      AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.Origination] =
      AwsError.unwrapOptionField("origination", origination)
    def getStartoverWindowSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("startoverWindowSeconds", startoverWindowSeconds)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTimeDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeDelaySeconds", timeDelaySeconds)
    def getWhitelist: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("whitelist", whitelist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest
  ) extends zio.aws.mediapackage.model.CreateOriginEndpointRequest.ReadOnly {
    override val authorization
        : Option[zio.aws.mediapackage.model.Authorization.ReadOnly] = scala
      .Option(impl.authorization())
      .map(value => zio.aws.mediapackage.model.Authorization.wrap(value))
    override val channelId: __string = impl.channelId(): __string
    override val cmafPackage: Option[
      zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters.ReadOnly
    ] = scala
      .Option(impl.cmafPackage())
      .map(value =>
        zio.aws.mediapackage.model.CmafPackageCreateOrUpdateParameters
          .wrap(value)
      )
    override val dashPackage
        : Option[zio.aws.mediapackage.model.DashPackage.ReadOnly] = scala
      .Option(impl.dashPackage())
      .map(value => zio.aws.mediapackage.model.DashPackage.wrap(value))
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val hlsPackage
        : Option[zio.aws.mediapackage.model.HlsPackage.ReadOnly] = scala
      .Option(impl.hlsPackage())
      .map(value => zio.aws.mediapackage.model.HlsPackage.wrap(value))
    override val id: __string = impl.id(): __string
    override val manifestName: Option[__string] =
      scala.Option(impl.manifestName()).map(value => value: __string)
    override val mssPackage
        : Option[zio.aws.mediapackage.model.MssPackage.ReadOnly] = scala
      .Option(impl.mssPackage())
      .map(value => zio.aws.mediapackage.model.MssPackage.wrap(value))
    override val origination: Option[zio.aws.mediapackage.model.Origination] =
      scala
        .Option(impl.origination())
        .map(value => zio.aws.mediapackage.model.Origination.wrap(value))
    override val startoverWindowSeconds: Option[__integer] =
      scala.Option(impl.startoverWindowSeconds()).map(value => value: __integer)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val timeDelaySeconds: Option[__integer] =
      scala.Option(impl.timeDelaySeconds()).map(value => value: __integer)
    override val whitelist: Option[List[__string]] = scala
      .Option(impl.whitelist())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest
  ): zio.aws.mediapackage.model.CreateOriginEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
