package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    description: Option[__string] = None,
    id: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.UpdateChannelRequest
      .builder()
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .id(__string.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.UpdateChannelRequest.ReadOnly =
    zio.aws.mediapackage.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.UpdateChannelRequest =
      zio.aws.mediapackage.model
        .UpdateChannelRequest(description.map(value => value), id)
    def description: Option[__string]
    def id: __string
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.UpdateChannelRequest
  ) extends zio.aws.mediapackage.model.UpdateChannelRequest.ReadOnly {
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.mediapackage.model.primitives.__string(value))
    override val id: __string =
      zio.aws.mediapackage.model.primitives.__string(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.UpdateChannelRequest
  ): zio.aws.mediapackage.model.UpdateChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
