package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters._
sealed trait PresetSpeke20Audio {
  def unwrap
      : software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio
}
object PresetSpeke20Audio {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio
  ): zio.aws.mediapackage.model.PresetSpeke20Audio = value match {
    case software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio.PRESET_AUDIO_1 =>
      val r = `PRESET-AUDIO-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.PresetSpeke20Audio {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio =
      software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio.UNKNOWN_TO_SDK_VERSION
  }
  case object `PRESET-AUDIO-1`
      extends zio.aws.mediapackage.model.PresetSpeke20Audio {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio =
      software.amazon.awssdk.services.mediapackage.model.PresetSpeke20Audio.PRESET_AUDIO_1
  }
}
