package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateHarvestJobRequest(
    endTime: __string,
    id: __string,
    originEndpointId: __string,
    s3Destination: zio.aws.mediapackage.model.S3Destination,
    startTime: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobRequest = {
    import CreateHarvestJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobRequest
      .builder()
      .endTime(__string.unwrap(endTime): java.lang.String)
      .id(__string.unwrap(id): java.lang.String)
      .originEndpointId(__string.unwrap(originEndpointId): java.lang.String)
      .s3Destination(s3Destination.buildAwsValue())
      .startTime(__string.unwrap(startTime): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.CreateHarvestJobRequest.ReadOnly =
    zio.aws.mediapackage.model.CreateHarvestJobRequest.wrap(buildAwsValue())
}
object CreateHarvestJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.CreateHarvestJobRequest =
      zio.aws.mediapackage.model.CreateHarvestJobRequest(
        endTime,
        id,
        originEndpointId,
        s3Destination.asEditable,
        startTime
      )
    def endTime: __string
    def id: __string
    def originEndpointId: __string
    def s3Destination: zio.aws.mediapackage.model.S3Destination.ReadOnly
    def startTime: __string
    def getEndTime: ZIO[Any, Nothing, __string] = ZIO.succeed(endTime)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getOriginEndpointId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(originEndpointId)
    def getS3Destination
        : ZIO[Any, Nothing, zio.aws.mediapackage.model.S3Destination.ReadOnly] =
      ZIO.succeed(s3Destination)
    def getStartTime: ZIO[Any, Nothing, __string] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobRequest
  ) extends zio.aws.mediapackage.model.CreateHarvestJobRequest.ReadOnly {
    override val endTime: __string =
      zio.aws.mediapackage.model.primitives.__string(impl.endTime())
    override val id: __string =
      zio.aws.mediapackage.model.primitives.__string(impl.id())
    override val originEndpointId: __string =
      zio.aws.mediapackage.model.primitives.__string(impl.originEndpointId())
    override val s3Destination
        : zio.aws.mediapackage.model.S3Destination.ReadOnly =
      zio.aws.mediapackage.model.S3Destination.wrap(impl.s3Destination())
    override val startTime: __string =
      zio.aws.mediapackage.model.primitives.__string(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.CreateHarvestJobRequest
  ): zio.aws.mediapackage.model.CreateHarvestJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
