package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__integer
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DashEncryption(
    keyRotationIntervalSeconds: Option[__integer] = None,
    spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DashEncryption = {
    import DashEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DashEncryption
      .builder()
      .optionallyWith(
        keyRotationIntervalSeconds.map(value =>
          __integer.unwrap(value): Integer
        )
      )(_.keyRotationIntervalSeconds)
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.DashEncryption.ReadOnly =
    zio.aws.mediapackage.model.DashEncryption.wrap(buildAwsValue())
}
object DashEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DashEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DashEncryption =
      zio.aws.mediapackage.model.DashEncryption(
        keyRotationIntervalSeconds.map(value => value),
        spekeKeyProvider.asEditable
      )
    def keyRotationIntervalSeconds: Option[__integer]
    def spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    def getKeyRotationIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "keyRotationIntervalSeconds",
        keyRotationIntervalSeconds
      )
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DashEncryption
  ) extends zio.aws.mediapackage.model.DashEncryption.ReadOnly {
    override val keyRotationIntervalSeconds: Option[__integer] = scala
      .Option(impl.keyRotationIntervalSeconds())
      .map(value => zio.aws.mediapackage.model.primitives.__integer(value))
    override val spekeKeyProvider
        : zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackage.model.SpekeKeyProvider.wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DashEncryption
  ): zio.aws.mediapackage.model.DashEncryption.ReadOnly = new Wrapper(impl)
}
