package zio.aws.managedblockchainquery.model
import zio.aws.managedblockchainquery.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BlockchainInstant(
    time: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant = {
    import BlockchainInstant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant
      .builder()
      .optionallyWith(time.map(value => Timestamp.unwrap(value): Instant))(
        _.time
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly =
    zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(buildAwsValue())
}
object BlockchainInstant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.BlockchainInstant =
      zio.aws.managedblockchainquery.model
        .BlockchainInstant(time.map(value => value))
    def time: Optional[Timestamp]
    def getTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("time", time)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant
  ) extends zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly {
    override val time: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.time())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant
  ): zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly =
    new Wrapper(impl)
}
